/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.messaging;

import cn.afternode.commons.bukkit.messaging.IMessageListener;
import cn.afternode.commons.bukkit.messaging.MessageChannelContext;
import cn.afternode.commons.bukkit.messaging.NBukkitByteBuf;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BukkitMessagingHelper {
    private final Plugin plugin;
    private SecretKeySpec key;

    public BukkitMessagingHelper(Plugin plugin) {
        this.plugin = plugin;
    }

    public MessageChannelContext register(String channel, IMessageListener listener) {
        MessageChannelContext context = new MessageChannelContext(channel, this, listener);
        Messenger messenger = Bukkit.getMessenger();
        messenger.registerOutgoingPluginChannel(this.plugin, channel);
        messenger.registerIncomingPluginChannel(this.plugin, channel, (PluginMessageListener)context);
        return context;
    }

    public boolean signingAvailable() {
        return this.key != null && !this.key.isDestroyed();
    }

    public void setKey(String key) {
        this.key = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
    }

    public byte[] sign(byte[] data) throws NoSuchAlgorithmException, InvalidKeyException {
        if (!this.signingAvailable()) {
            throw new IllegalStateException("Signing not available");
        }
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(this.key);
        return mac.doFinal(data);
    }

    public byte[] combineSign(NBukkitByteBuf buf) throws NoSuchAlgorithmException, InvalidKeyException {
        NBukkitByteBuf nBuf = new NBukkitByteBuf();
        byte[] data = buf.toArray();
        nBuf.writeBlock(this.sign(data));
        nBuf.writeBlock(data);
        return nBuf.toArray();
    }

    public boolean validate(byte[] sign, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException {
        if (!this.signingAvailable()) {
            throw new IllegalStateException("Signing not available");
        }
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(this.key);
        return Arrays.equals(sign, mac.doFinal(data));
    }

    public NBukkitByteBuf validateCombined(NBukkitByteBuf buf) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] data;
        byte[] sign = buf.readBlock();
        if (!this.validate(sign, data = buf.readBlock())) {
            return null;
        }
        return new NBukkitByteBuf(data);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

