/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.configurations;

import cn.afternode.commons.bukkit.configurations.ConfigSerialization;
import cn.afternode.commons.serialization.DeserializeInstantiationException;
import cn.afternode.commons.serialization.FieldAccessException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.configuration.ConfigurationSection;

public class ConfigurationsSerializer {
    public static <T> T deserialize(ConfigurationSection config, T object) {
        for (Field f : object.getClass().getFields()) {
            try {
                if (f.isAnnotationPresent(ConfigSerialization.Ignore.class)) continue;
                String key = f.isAnnotationPresent(ConfigSerialization.Name.class) ? f.getAnnotation(ConfigSerialization.Name.class).value() : f.getName();
                if (f.isAnnotationPresent(ConfigSerialization.Serialize.class)) {
                    Object sub = f.get(object);
                    ConfigurationSection sec = config.getConfigurationSection(key);
                    if (sub == null) {
                        sub = ConfigurationsSerializer.deserialize(sec, f.getType());
                        f.set(object, sub);
                        continue;
                    }
                    ConfigurationsSerializer.deserialize(sec, sub);
                    continue;
                }
                f.set(object, config.get(key));
            }
            catch (IllegalAccessException ex) {
                throw new FieldAccessException(f, ex);
            }
        }
        return object;
    }

    public static <T> T deserialize(ConfigurationSection config, Class<T> type) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            T instance = constructor.newInstance(new Object[0]);
            if (config == null) {
                return instance;
            }
            return ConfigurationsSerializer.deserialize(config, instance);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new DeserializeInstantiationException("Type %s".formatted(type.getName()), (Throwable)ex);
        }
    }

    public static void serialize(ConfigurationSection dest, Object src) throws FieldAccessException {
        for (Field f : src.getClass().getFields()) {
            if (f.isAnnotationPresent(ConfigSerialization.Ignore.class)) continue;
            String key = f.isAnnotationPresent(ConfigSerialization.Name.class) ? f.getAnnotation(ConfigSerialization.Name.class).value() : f.getName();
            f.trySetAccessible();
            try {
                if (f.isAnnotationPresent(ConfigSerialization.Serialize.class)) {
                    ConfigurationSection sec = dest.createSection(f.getName());
                    ConfigurationsSerializer.serialize(sec, f.get(src));
                    dest.set(key, (Object)sec);
                    continue;
                }
                dest.set(key, f.get(src));
            }
            catch (IllegalAccessException ex) {
                throw new FieldAccessException(f, ex);
            }
        }
    }
}

