/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.message;

import cn.afternode.commons.localizations.ILocalizations;
import java.awt.Color;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.Nullable;

public class MessageBuilder {
    private ILocalizations localizations;
    private ComponentLike linePrefix = Component.text();
    private CommandSender sender;
    private final TextComponent.Builder component = Component.text();

    public MessageBuilder(@Nullable ILocalizations locale, @Nullable ComponentLike linePrefix, @Nullable CommandSender sender) {
        this.localizations = locale;
        if (linePrefix != null) {
            this.linePrefix = linePrefix;
        }
        this.sender = sender;
        this.component.append(this.linePrefix);
    }

    public MessageBuilder(@Nullable ILocalizations locale) {
        this(locale, null, null);
    }

    public MessageBuilder() {
        this(null, null, null);
    }

    public MessageBuilder localize(String key, Map<String, Object> placeholders) {
        if (this.localizations == null) {
            throw new NullPointerException("No localizations passed to this builder");
        }
        this.component.append((Component)Component.text((String)this.localizations.get(key, placeholders)));
        return this;
    }

    public MessageBuilder text(String text) {
        this.component.append((Component)Component.text((String)text));
        return this;
    }

    public MessageBuilder text(String text, Color color) {
        this.component.append(Component.text((String)text).color(TextColor.color((int)color.getRGB())));
        return this;
    }

    public MessageBuilder mini(String mini) {
        this.component.append(MiniMessage.miniMessage().deserialize((Object)mini));
        return this;
    }

    public MessageBuilder hover(HoverEventSource<?> source) {
        this.component.hoverEvent(source);
        return this;
    }

    public MessageBuilder click(ClickEvent event) {
        this.component.clickEvent(event);
        return this;
    }

    public MessageBuilder append(ComponentLike componentLike) {
        this.component.append(componentLike);
        return this;
    }

    public MessageBuilder line() {
        this.component.appendNewline();
        this.component.append(this.linePrefix);
        return this;
    }

    public MessageBuilder emptyLine() {
        this.component.appendNewline();
        return this;
    }

    public MessageBuilder permission(String permission, ComponentLike componentLike) {
        if (this.sender.hasPermission(permission)) {
            this.component.append(componentLike);
        }
        return this;
    }

    public MessageBuilder permission(Permission permission, ComponentLike component) {
        if (this.sender.hasPermission(permission)) {
            this.component.append(component);
        }
        return this;
    }

    public TextComponent build() {
        return (TextComponent)this.component.build();
    }

    public void send() {
        if (this.sender == null) {
            throw new NullPointerException("No sender passed to this builder");
        }
        this.sender.sendMessage((Component)this.build());
    }

    public void send(CommandSender sender) {
        sender.sendMessage((Component)this.build());
    }

    public ILocalizations getLocalizations() {
        return this.localizations;
    }

    public MessageBuilder localizations(ILocalizations localizations) {
        this.localizations = localizations;
        return this;
    }

    public ComponentLike getLinePrefix() {
        return this.linePrefix;
    }

    public MessageBuilder linePrefix(ComponentLike prefix) {
        this.linePrefix = prefix;
        return this;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public MessageBuilder sender(CommandSender sender) {
        this.sender = sender;
        return this;
    }
}

