/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit;

import cn.afternode.commons.ReflectionError;
import cn.afternode.commons.bukkit.BukkitReflections;
import cn.afternode.commons.bukkit.annotations.RegisterCommand;
import cn.afternode.commons.bukkit.annotations.RegisterPluginCommand;
import cn.afternode.commons.serialization.FieldAccessException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

public class BukkitPluginContext {
    private final Plugin plugin;

    public BukkitPluginContext(Plugin plg) {
        this.plugin = plg;
    }

    public void registerPluginCommands(String packageName) throws RuntimeException {
        Reflections ref = new Reflections(packageName, new Scanner[0]);
        Set classes = ref.get(Scanners.SubTypes.of(Scanners.TypesAnnotated.with(new AnnotatedElement[]{RegisterPluginCommand.class})).asClass(new ClassLoader[0]));
        for (Class c : classes) {
            try {
                if (!(CommandExecutor.class.isAssignableFrom(c) || TabCompleter.class.isAssignableFrom(c) || TabExecutor.class.isAssignableFrom(c))) {
                    throw new IllegalArgumentException("%s is not a valid CommandExecutor/TabExecutor but a RegisterPluginCommand annotation was present".formatted(c.getName()));
                }
                RegisterPluginCommand anno = c.getAnnotation(RegisterPluginCommand.class);
                PluginCommand cmd = Bukkit.getPluginCommand((String)anno.name());
                if (cmd == null) {
                    throw new NullPointerException("Cannot find plugin command %s".formatted(anno.name()));
                }
                Constructor constructor = c.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                Object instance = constructor.newInstance(new Object[0]);
                if (instance instanceof CommandExecutor) {
                    cmd.setExecutor((CommandExecutor)instance);
                }
                if (!(instance instanceof TabCompleter)) continue;
                cmd.setTabCompleter((TabCompleter)instance);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot register %s as a plugin command".formatted(c.getName()), t);
            }
        }
    }

    public void registerCommands(String packageName) {
        Reflections ref = new Reflections(packageName, new Scanner[0]);
        Set classes = ref.get(Scanners.SubTypes.of(Scanners.TypesAnnotated.with(new AnnotatedElement[]{RegisterCommand.class})).asClass(new ClassLoader[0]));
        SimpleCommandMap map = BukkitReflections.getCommandMap();
        for (Class c : classes) {
            Command inst;
            Constructor cons;
            if (!Command.class.isAssignableFrom(c)) {
                throw new IllegalArgumentException("%s is not a valid Command class but a RegisterCommand annotation was present".formatted(c.getName()));
            }
            try {
                cons = c.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionError(c, (Throwable)e);
            }
            cons.trySetAccessible();
            try {
                inst = (Command)cons.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new ReflectionError(cons, c, (Throwable)e);
            }
            map.register(this.plugin.getName(), inst);
        }
    }

    public void registerListeners(String packageName) {
        Reflections ref = new Reflections(packageName, new Scanner[0]);
        Set classes = ref.get(Scanners.SubTypes.of(Scanners.TypesAnnotated.with(new AnnotatedElement[]{RegisterPluginCommand.class})).asClass(new ClassLoader[0]));
        for (Class c : classes) {
            try {
                if (!Listener.class.isAssignableFrom(c)) {
                    throw new IllegalArgumentException("%s is not assignable from org.bukkit.event.Listener".formatted(c.getName()));
                }
                Constructor constructor = c.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                Bukkit.getPluginManager().registerEvents((Listener)constructor.newInstance(new Object[0]), this.plugin);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot register %s as an event listener".formatted(c.getName()), t);
            }
        }
    }

    public void setDisplayName(String name) {
        Field field = null;
        try {
            field = PluginDescriptionFile.class.getDeclaredField("name");
            field.trySetAccessible();
            field.set(this.plugin.getDescription(), name);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionError(PluginDescriptionFile.class, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException(field, e);
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

