/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;

public class TabBuilder {
    private CommandSender sender = null;
    private final List<String> list = new ArrayList<String>();

    public TabBuilder(CommandSender sender) {
        this.sender = sender;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public TabBuilder sender(CommandSender sender) {
        this.sender = sender;
        return this;
    }

    public TabBuilder add(String prefix, String ... items) {
        for (String i : items) {
            if (!i.startsWith(prefix)) continue;
            this.list.add(i);
        }
        return this;
    }

    public TabBuilder players(String prefix) {
        Bukkit.getOnlinePlayers().parallelStream().map(Player::getName).filter(s -> s.startsWith(prefix)).forEach(this.list::add);
        return this;
    }

    public TabBuilder players(Predicate<Player> filter) {
        Bukkit.getOnlinePlayers().stream().filter(filter).forEach(p -> this.list.add(p.getName()));
        return this;
    }

    public TabBuilder worlds(String prefix) {
        for (World w : Bukkit.getWorlds()) {
            if (!w.getName().startsWith(prefix)) continue;
            this.list.add(w.getName());
        }
        return this;
    }

    public TabBuilder worlds(Predicate<World> filter) {
        for (World w : Bukkit.getWorlds()) {
            if (!filter.test(w)) continue;
            this.list.add(w.getName());
        }
        return this;
    }

    public TabBuilder permission(String permission, String prefix, String ... items) {
        this.checkSender();
        if (this.sender.hasPermission(permission)) {
            for (String i : items) {
                if (!i.startsWith(prefix)) continue;
                this.list.add(i);
            }
        }
        return this;
    }

    public TabBuilder permission(String permission, String ... items) {
        if (this.sender.hasPermission(permission)) {
            Collections.addAll(this.list, items);
        }
        return this;
    }

    public TabBuilder permission(Permission permission, String prefix, String ... items) {
        this.checkSender();
        if (this.sender.hasPermission(permission)) {
            for (String i : items) {
                if (!i.startsWith(prefix)) continue;
                this.list.add(i);
            }
        }
        return this;
    }

    public TabBuilder permission(Permission permission, String ... items) {
        this.checkSender();
        if (this.sender.hasPermission(permission)) {
            Collections.addAll(this.list, items);
        }
        return this;
    }

    public List<String> build() {
        return new ArrayList<String>(this.list);
    }

    private void checkSender() {
        if (this.sender == null) {
            throw new NullPointerException("No sender passed to this builder");
        }
    }
}

