/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class BukkitResolver {
    public static Player resolvePlayerOnline(String resolve) {
        if (resolve.startsWith("uuid:")) {
            UUID id;
            String uuidStr = resolve.substring(5);
            try {
                id = UUID.fromString(uuidStr);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid uuid %s".formatted(uuidStr), e);
            }
            return Bukkit.getPlayer((UUID)id);
        }
        return Bukkit.getPlayer((String)resolve);
    }

    public static OfflinePlayer resolvePlayer(String resolve) {
        if (resolve.startsWith("uuid:")) {
            UUID id;
            String uuidStr = resolve.substring(5);
            try {
                id = UUID.fromString(uuidStr);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid uuid %s".formatted(uuidStr), e);
            }
            return Objects.requireNonNullElse(Bukkit.getPlayer((UUID)id), Bukkit.getOfflinePlayer((UUID)id));
        }
        return Bukkit.getPlayer((String)resolve);
    }
}

