/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit;

import cn.afternode.commons.bukkit.annotations.RegisterListener;
import cn.afternode.commons.bukkit.annotations.RegisterPluginCommand;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

public class Registration {
    private final Plugin plugin;

    public Registration(Plugin plg) {
        this.plugin = plg;
    }

    public void registerPluginCommands(String packageName) throws RuntimeException {
        Reflections ref = new Reflections(packageName, new Scanner[0]);
        Set classes = ref.get(Scanners.SubTypes.of(Scanners.TypesAnnotated.with(new AnnotatedElement[]{RegisterPluginCommand.class})).asClass(new ClassLoader[0]));
        for (Class c : classes) {
            try {
                if (!(CommandExecutor.class.isAssignableFrom(c) || TabCompleter.class.isAssignableFrom(c) || TabExecutor.class.isAssignableFrom(c))) {
                    throw new IllegalArgumentException("%s is not a valid CommandExecutor/TabExecutor but a RegisterPluginCommand annotation was present".formatted(c.getName()));
                }
                RegisterPluginCommand anno = c.getAnnotation(RegisterPluginCommand.class);
                PluginCommand cmd = Bukkit.getPluginCommand((String)anno.name());
                if (cmd == null) {
                    throw new NullPointerException("Cannot find plugin command %s".formatted(anno.name()));
                }
                Constructor constructor = c.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                Object instance = constructor.newInstance(new Object[0]);
                if (instance instanceof CommandExecutor) {
                    cmd.setExecutor((CommandExecutor)instance);
                }
                if (!(instance instanceof TabCompleter)) continue;
                cmd.setTabCompleter((TabCompleter)instance);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot register %s as a plugin command".formatted(c.getName()), t);
            }
        }
    }

    public void registerListeners(String packageName) {
        Reflections ref = new Reflections(packageName, new Scanner[0]);
        Set classes = ref.get(Scanners.SubTypes.of(Scanners.TypesAnnotated.with(new AnnotatedElement[]{RegisterPluginCommand.class})).asClass(new ClassLoader[0]));
        for (Class c : classes) {
            try {
                if (!Listener.class.isAssignableFrom(c)) {
                    throw new IllegalArgumentException("%s is not assignable from org.bukkit.event.Listener".formatted(c.getName()));
                }
                RegisterListener anno = c.getAnnotation(RegisterListener.class);
                Constructor constructor = c.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                Bukkit.getPluginManager().registerEvents((Listener)constructor.newInstance(new Object[0]), this.plugin);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot register %s as an event listener".formatted(c.getName()), t);
            }
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

