/*
 * Decompiled with CFR 0.152.
 */
package cn.aethli.lunar;

import cn.aethli.lunar.exception.LunarException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class LunarDate {
    private static final int MIN_LUNAR_YEAR = 1901;
    private static final int MAX_LUNAR_YEAR = 2100;
    private static final int MAX_DAY_IN_YEAR = 384;
    private static final int MAX_LUNAR_MONTH = 13;
    private static final int MAX_DAY_IN_MONTH = 30;
    private static final String[] DAY_HEADER = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345"};
    private static final String[] NUMBER = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};
    private static final String[] MONTH_NAME = new String[]{"\u6b63\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u51ac\u6708", "\u814a\u6708"};
    private static final String LEAP_HEADER = "\u95f0";
    private static final String[] YEAR_NAME = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final int[][] YEAR_INFO = new int[][]{{0, 2, 19, 19168}, {0, 2, 8, 42352}, {5, 1, 29, 21096}, {0, 2, 16, 53856}, {0, 2, 4, 55632}, {4, 1, 25, 27304}, {0, 2, 13, 22176}, {0, 2, 2, 39632}, {2, 1, 22, 19176}, {0, 2, 10, 19168}, {6, 1, 30, 42200}, {0, 2, 18, 42192}, {0, 2, 6, 53840}, {5, 1, 26, 54568}, {0, 2, 14, 46400}, {0, 2, 3, 54944}, {2, 1, 23, 38608}, {0, 2, 11, 38320}, {7, 2, 1, 18872}, {0, 2, 20, 18800}, {0, 2, 8, 42160}, {5, 1, 28, 45656}, {0, 2, 16, 27216}, {0, 2, 5, 27968}, {4, 1, 24, 44456}, {0, 2, 13, 11104}, {0, 2, 2, 38256}, {2, 1, 23, 18808}, {0, 2, 10, 18800}, {6, 1, 30, 25776}, {0, 2, 17, 54432}, {0, 2, 6, 59984}, {5, 1, 26, 27976}, {0, 2, 14, 23248}, {0, 2, 4, 11104}, {3, 1, 24, 37744}, {0, 2, 11, 37600}, {7, 1, 31, 51560}, {0, 2, 19, 51536}, {0, 2, 8, 54432}, {6, 1, 27, 55888}, {0, 2, 15, 46416}, {0, 2, 5, 22176}, {4, 1, 25, 43736}, {0, 2, 13, 9680}, {0, 2, 2, 37584}, {2, 1, 22, 51544}, {0, 2, 10, 43344}, {7, 1, 29, 46248}, {0, 2, 17, 27808}, {0, 2, 6, 46416}, {5, 1, 27, 21928}, {0, 2, 14, 19872}, {0, 2, 3, 42416}, {3, 1, 24, 21176}, {0, 2, 12, 21168}, {8, 1, 31, 43344}, {0, 2, 18, 59728}, {0, 2, 8, 27296}, {6, 1, 28, 44368}, {0, 2, 15, 43856}, {0, 2, 5, 19296}, {4, 1, 25, 42352}, {0, 2, 13, 42352}, {0, 2, 2, 21088}, {3, 1, 21, 59696}, {0, 2, 9, 55632}, {7, 1, 30, 23208}, {0, 2, 17, 22176}, {0, 2, 6, 38608}, {5, 1, 27, 19176}, {0, 2, 15, 19152}, {0, 2, 3, 42192}, {4, 1, 23, 53864}, {0, 2, 11, 53840}, {8, 1, 31, 54568}, {0, 2, 18, 46400}, {0, 2, 7, 46752}, {6, 1, 28, 38608}, {0, 2, 16, 38320}, {0, 2, 5, 18864}, {4, 1, 25, 42168}, {0, 2, 13, 42160}, {10, 2, 2, 45656}, {0, 2, 20, 27216}, {0, 2, 9, 27968}, {6, 1, 29, 44448}, {0, 2, 17, 43872}, {0, 2, 6, 38256}, {5, 1, 27, 18808}, {0, 2, 15, 18800}, {0, 2, 4, 25776}, {3, 1, 23, 27216}, {0, 2, 10, 59984}, {8, 1, 31, 27432}, {0, 2, 19, 23232}, {0, 2, 7, 43872}, {5, 1, 28, 37736}, {0, 2, 16, 37600}, {0, 2, 5, 51552}, {4, 1, 24, 54440}, {0, 2, 12, 54432}, {0, 2, 1, 55888}, {2, 1, 22, 23208}, {0, 2, 9, 22176}, {7, 1, 29, 43736}, {0, 2, 18, 9680}, {0, 2, 7, 37584}, {5, 1, 26, 51544}, {0, 2, 14, 43344}, {0, 2, 3, 46240}, {4, 1, 23, 46416}, {0, 2, 10, 44368}, {9, 1, 31, 21928}, {0, 2, 19, 19360}, {0, 2, 8, 42416}, {6, 1, 28, 21176}, {0, 2, 16, 21168}, {0, 2, 5, 43312}, {4, 1, 25, 29864}, {0, 2, 12, 27296}, {0, 2, 1, 44368}, {2, 1, 22, 19880}, {0, 2, 10, 19296}, {6, 1, 29, 42352}, {0, 2, 17, 42208}, {0, 2, 6, 53856}, {5, 1, 26, 59696}, {0, 2, 13, 54576}, {0, 2, 3, 23200}, {3, 1, 23, 27472}, {0, 2, 11, 38608}, {11, 1, 31, 19176}, {0, 2, 19, 19152}, {0, 2, 8, 42192}, {6, 1, 28, 53848}, {0, 2, 15, 53840}, {0, 2, 4, 54560}, {5, 1, 24, 55968}, {0, 2, 12, 46496}, {0, 2, 1, 22224}, {2, 1, 22, 19160}, {0, 2, 10, 18864}, {7, 1, 30, 42168}, {0, 2, 17, 42160}, {0, 2, 6, 43600}, {5, 1, 26, 46376}, {0, 2, 14, 27936}, {0, 2, 2, 44448}, {3, 1, 23, 21936}, {0, 2, 11, 37744}, {8, 2, 1, 18808}, {0, 2, 19, 18800}, {0, 2, 8, 25776}, {6, 1, 28, 27216}, {0, 2, 15, 59984}, {0, 2, 4, 27296}, {4, 1, 24, 43872}, {0, 2, 12, 43744}, {0, 2, 2, 37600}, {3, 1, 21, 51568}, {0, 2, 9, 51552}, {7, 1, 29, 54440}, {0, 2, 17, 54432}, {0, 2, 5, 55888}, {5, 1, 26, 23208}, {0, 2, 14, 22176}, {0, 2, 3, 42704}, {4, 1, 23, 21224}, {0, 2, 11, 21200}, {8, 1, 31, 43352}, {0, 2, 19, 43344}, {0, 2, 7, 46240}, {6, 1, 27, 46416}, {0, 2, 15, 44368}, {0, 2, 5, 21920}, {4, 1, 24, 42448}, {0, 2, 12, 42416}, {0, 2, 2, 21168}, {3, 1, 22, 43320}, {0, 2, 9, 26928}, {7, 1, 29, 29336}, {0, 2, 17, 27296}, {0, 2, 6, 44368}, {5, 1, 26, 19880}, {0, 2, 14, 19296}, {0, 2, 3, 42352}, {4, 1, 24, 21104}, {0, 2, 10, 53600}, {8, 1, 30, 59696}, {0, 2, 18, 54560}, {0, 2, 7, 55968}, {6, 1, 27, 27472}, {0, 2, 15, 22224}, {0, 2, 5, 19168}, {4, 1, 25, 42216}, {0, 2, 12, 41680}, {0, 2, 1, 53584}, {2, 1, 21, 55592}, {0, 2, 9, 54560}};
    private String yearName;
    private String monthName;
    private String dayName;
    private int year;
    private int month;
    private int day;
    private LeapType leapType;
    private LocalDate gregorianDate;

    private LunarDate(int year, int month, int day, LeapType leapType) {
        this.year = year;
        this.month = month - 1;
        this.day = day;
        this.leapType = leapType;
        int[] thisYearInfo = YEAR_INFO[year - 1901];
        int[] daysPerMonth = LunarDate.toBinaryInts(thisYearInfo[3]);
        LocalDate thisChineseNewYear = LocalDate.of(year, thisYearInfo[1], thisYearInfo[2]);
        int dayCount = 0;
        for (int i = 1; i <= month; ++i) {
            if (i < month) {
                dayCount = dayCount + daysPerMonth[i] == 0 ? 29 : 30;
                continue;
            }
            dayCount += day;
        }
        this.gregorianDate = thisChineseNewYear.plusDays(dayCount);
        this.updateLunarName(thisYearInfo);
    }

    private LunarDate(LocalDate gregorianDate) throws LunarException {
        this.gregorianDate = gregorianDate;
        int[] thisYearInfo = YEAR_INFO[gregorianDate.getYear() - 1901];
        LocalDate thisChineseNewYear = LocalDate.of(gregorianDate.getYear(), thisYearInfo[1], thisYearInfo[2]);
        if (thisChineseNewYear.isAfter(gregorianDate)) {
            thisYearInfo = YEAR_INFO[gregorianDate.getYear() - 1901 - 1];
            thisChineseNewYear = LocalDate.of(gregorianDate.getYear() - 1, thisYearInfo[1], thisYearInfo[2]);
        }
        long between = ChronoUnit.DAYS.between(thisChineseNewYear, gregorianDate);
        this.year = thisChineseNewYear.getYear();
        this.month = 0;
        this.day = 0;
        this.leapType = LeapType.NOT_LEAP;
        int[] daysPerMonth = LunarDate.toBinaryInts(thisYearInfo[3]);
        for (int i = 0; i < 16; ++i) {
            if ((long)(daysPerMonth[i] == 0 ? 29 : 30) >= between) {
                if (this.month == 0) {
                    this.day = (int)between;
                    break;
                }
                this.day = (int)between - 1;
                break;
            }
            if (i == 15) {
                throw new LunarException("unknown error 0");
            }
            ++this.month;
            between -= (long)(daysPerMonth[i] == 0 ? 29 : 30);
        }
        this.updateLunarName(thisYearInfo);
    }

    private static int[] toBinaryInts(int res) {
        int[] ints = new int[16];
        for (int i = 16; i > 0; --i) {
            ints[i - 1] = res % 2;
            res /= 2;
        }
        return ints;
    }

    public static LunarDate getInstance(LocalDate gregorianDate) throws LunarException {
        if (gregorianDate.getYear() < 1901 || gregorianDate.getYear() > 2100) {
            throw new LunarException("out of Range");
        }
        return new LunarDate(gregorianDate);
    }

    public static LunarDate[] ofMonth(LocalDate gregorianDate) throws LunarException {
        LunarDate[] lunarDates = new LunarDate[30];
        if (gregorianDate.getYear() < 1901 || gregorianDate.getYear() > 2100) {
            throw new LunarException("out of Range");
        }
        gregorianDate = gregorianDate.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate endDate = gregorianDate.with(TemporalAdjusters.lastDayOfMonth());
        long between = ChronoUnit.DAYS.between(gregorianDate, endDate);
        int i = 0;
        while ((long)i < between) {
            lunarDates[i] = new LunarDate(gregorianDate.plusDays(i));
            ++i;
        }
        ArrayList<LunarDate> dates = new ArrayList<LunarDate>(Arrays.asList(lunarDates));
        dates.removeIf(Objects::isNull);
        return dates.toArray(new LunarDate[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LunarDate[] ofMonth(int year, int month, LeapType leapType) throws LunarException {
        ArrayList<LunarDate> lunarDateList = new ArrayList<LunarDate>();
        if (year < 1901 || year > 2100 || month < 0 || month > 13) {
            throw new LunarException("out of Range");
        }
        int[] thisYearInfo = YEAR_INFO[year - 1901];
        int dayCount = 0;
        if (leapType == LeapType.LEAP_1) {
            if (month != thisYearInfo[0]) throw new LunarException("not leap month");
            dayCount = LunarDate.toBinaryInts(thisYearInfo[3])[month - 2] == 0 ? 29 : 30;
        } else {
            dayCount = LunarDate.toBinaryInts(thisYearInfo[3])[month - 1] == 0 ? 29 : 30;
        }
        for (int i = 0; i < dayCount; ++i) {
            lunarDateList.add(new LunarDate(year, month, i, leapType));
        }
        return lunarDateList.toArray(new LunarDate[0]);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        if (this.leapType == LeapType.LEAP_1) {
            return this.month;
        }
        return this.month + 1;
    }

    public LeapType getLeapType() {
        return this.leapType;
    }

    public int getDay() {
        return this.day + 1;
    }

    private void updateLunarName(int[] thisYearInfo) {
        this.dayName = "";
        if (this.day + 1 <= 10) {
            this.dayName = this.dayName + DAY_HEADER[0];
            this.dayName = this.dayName + NUMBER[this.day + 1];
        } else if (this.day + 1 < 20) {
            this.dayName = this.dayName + DAY_HEADER[1];
            this.dayName = this.dayName + NUMBER[this.day + 1 - 10];
        } else if (this.day + 1 == 20) {
            this.dayName = this.dayName + NUMBER[2];
            this.dayName = this.dayName + NUMBER[10];
        } else if (this.day + 1 < 30) {
            this.dayName = this.dayName + DAY_HEADER[2];
            this.dayName = this.dayName + NUMBER[this.day + 1 - 20];
        } else if (this.day + 1 == 30) {
            this.dayName = this.dayName + NUMBER[3];
            this.dayName = this.dayName + NUMBER[10];
        } else {
            this.dayName = this.dayName + DAY_HEADER[3];
            this.dayName = this.dayName + NUMBER[this.day + 1 - 30];
        }
        if (thisYearInfo[0] == 0) {
            thisYearInfo[0] = 999;
        }
        if (this.month + 1 < thisYearInfo[0] + 1) {
            this.monthName = MONTH_NAME[this.month];
            this.leapType = LeapType.NOT_LEAP;
        } else if (this.month + 1 == thisYearInfo[0]) {
            this.leapType = LeapType.LEAP_0;
        } else if (this.month + 1 == thisYearInfo[0] + 1) {
            this.monthName = LEAP_HEADER + MONTH_NAME[this.month - 1];
            this.leapType = LeapType.LEAP_1;
        } else {
            this.monthName = MONTH_NAME[this.month - 1];
            this.leapType = LeapType.NOT_LEAP;
        }
        this.yearName = String.valueOf(this.year);
        this.yearName = this.yearName.replace("0", YEAR_NAME[0]);
        this.yearName = this.yearName.replace("1", YEAR_NAME[1]);
        this.yearName = this.yearName.replace("2", YEAR_NAME[2]);
        this.yearName = this.yearName.replace("3", YEAR_NAME[3]);
        this.yearName = this.yearName.replace("4", YEAR_NAME[4]);
        this.yearName = this.yearName.replace("5", YEAR_NAME[5]);
        this.yearName = this.yearName.replace("6", YEAR_NAME[6]);
        this.yearName = this.yearName.replace("7", YEAR_NAME[7]);
        this.yearName = this.yearName.replace("8", YEAR_NAME[8]);
        this.yearName = this.yearName.replace("9", YEAR_NAME[9]);
    }

    public String toString() {
        return String.format("lunar:%s-%s-%s-%s-%s-%s(%s)\tgregorian:%s", this.yearName, this.monthName, this.dayName, this.getYear(), this.getMonth(), this.getDay(), this.getLeapType().toString(), this.gregorianDate.toString());
    }

    public LocalDate getGregorianDate() {
        return this.gregorianDate;
    }

    public LunarDate setGregorianDate(LocalDate gregorianDate) throws LunarException {
        if (gregorianDate.getYear() < 1901 || gregorianDate.getYear() > 2100) {
            throw new LunarException("out of Range");
        }
        return new LunarDate(gregorianDate);
    }

    public LunarDate setLunarDate(int year, int month, int day, LeapType leapType) throws LunarException {
        if (year < 1901 || year > 2100 || month < 0 || month > 13 || day < 0 || day > 30) {
            throw new LunarException("out of Range");
        }
        return new LunarDate(year, month, day, leapType);
    }

    public static enum LeapType {
        NOT_LEAP,
        LEAP_0,
        LEAP_1;


        public String toString() {
            switch (this) {
                case NOT_LEAP: 
                case LEAP_0: {
                    return "\u975e\u95f0\u6708";
                }
                case LEAP_1: {
                    return "\u95f0\u6708";
                }
            }
            return null;
        }
    }
}

