/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.shuaidd.dto.oa.ApplyDataContent;
import com.github.shuaidd.json.AbstractApplyFormControlDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ApplyFormControlDeserializer
extends AbstractApplyFormControlDeserializer<List<ApplyDataContent>> {
    public List<ApplyDataContent> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ArrayList<ApplyDataContent> applyDataContents = new ArrayList<ApplyDataContent>();
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        ArrayNode root = (ArrayNode)mapper.readTree(jp);
        for (JsonNode jsonNode : root) {
            ApplyDataContent applyDataContent = new ApplyDataContent();
            String control = jsonNode.get("control").textValue();
            applyDataContent.setControl(control);
            String id = jsonNode.get("id").textValue();
            applyDataContent.setId(id);
            JsonNode titleNode = jsonNode.get("title");
            applyDataContent.setTitle(this.getTitle(titleNode));
            JsonNode valueNode = jsonNode.get("value");
            applyDataContent.setValue(this.getApplyFormControl(control, valueNode, mapper));
            applyDataContents.add(applyDataContent);
        }
        return applyDataContents;
    }
}

