/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.json;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.shuaidd.dto.oa.formcontrol.ApplyFormControl;
import com.github.shuaidd.dto.oa.formcontrol.AttendanceFormControl;
import com.github.shuaidd.dto.oa.formcontrol.ContactFormControl;
import com.github.shuaidd.dto.oa.formcontrol.DateFormControl;
import com.github.shuaidd.dto.oa.formcontrol.DateRangeFormControl;
import com.github.shuaidd.dto.oa.formcontrol.FileFormControl;
import com.github.shuaidd.dto.oa.formcontrol.FormulaFormControl;
import com.github.shuaidd.dto.oa.formcontrol.LocationFormControl;
import com.github.shuaidd.dto.oa.formcontrol.MoneyFormControl;
import com.github.shuaidd.dto.oa.formcontrol.NumberFormControl;
import com.github.shuaidd.dto.oa.formcontrol.RelatedApprovalFormControl;
import com.github.shuaidd.dto.oa.formcontrol.SelectorFormControl;
import com.github.shuaidd.dto.oa.formcontrol.TableFormControl;
import com.github.shuaidd.dto.oa.formcontrol.TextFormControl;
import com.github.shuaidd.dto.oa.formcontrol.VacationFormControl;
import com.github.shuaidd.dto.template.TemplateText;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractApplyFormControlDeserializer<T>
extends JsonDeserializer<T> {
    protected static final Map<String, Class<? extends ApplyFormControl>> APPLY_FORM_CONTROL_MAP = new HashMap<String, Class<? extends ApplyFormControl>>();

    protected List<TemplateText> getTitle(JsonNode titleNode) {
        if (Objects.nonNull(titleNode)) {
            ArrayList<TemplateText> title = new ArrayList<TemplateText>(2);
            ArrayNode arrayNode = (ArrayNode)titleNode;
            for (JsonNode node : arrayNode) {
                String text = node.get("text").textValue();
                String lang = node.get("lang").textValue();
                TemplateText templateText = new TemplateText(text, lang);
                title.add(templateText);
            }
            return title;
        }
        return null;
    }

    protected ApplyFormControl getApplyFormControl(String control, JsonNode valueNode, ObjectMapper mapper) throws IOException {
        if (Objects.nonNull(valueNode)) {
            Class<? extends ApplyFormControl> cls = APPLY_FORM_CONTROL_MAP.get(control);
            if (Objects.isNull(cls)) {
                return null;
            }
            return (ApplyFormControl)mapper.readValue(valueNode.toString(), cls);
        }
        return null;
    }

    static {
        APPLY_FORM_CONTROL_MAP.put("Text", TextFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("Textarea", TextFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("Attendance", AttendanceFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("Contact", ContactFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("Date", DateFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("DateRange", DateRangeFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("File", FileFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("Formula", FormulaFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("Location", LocationFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("Money", MoneyFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("Number", NumberFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("RelatedApproval", RelatedApprovalFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("Selector", SelectorFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("Table", TableFormControl.class);
        APPLY_FORM_CONTROL_MAP.put("Vacation", VacationFormControl.class);
    }
}

