package com.github.shuaidd.enums;


import java.util.Objects;

/**
 * @author ddshuai
 * 创建日期： 2018/6/13
 * 描述：微信端企业微信所有相关错误码描述
 */
public enum ErrorCode {
    /**
     * 所有企业微信错误码
     */
    ERROR_CODE_1("-1", "系统繁忙"),
    ERROR_CODE_0("0", "请求成功"),
    ERROR_CODE_40001("40001", "不合法的secret参数"),
    ERROR_CODE_40003("40003", "无效的UserID"),
    ERROR_CODE_40004("40004", "不合法的媒体文件类型"),
    ERROR_CODE_40005("40005", "不合法的type参数"),
    ERROR_CODE_40006("40006", "不合法的文件大小"),
    ERROR_CODE_40007("40007", "不合法的media_id参数"),
    ERROR_CODE_40008("40008", "不合法的msgtype参数"),
    ERROR_CODE_40009("40009", "上传图片大小不是有效值"),
    ERROR_CODE_40011("40011", "上传视频大小不是有效值"),
    ERROR_CODE_40013("40013", "不合法的CorpID"),
    ERROR_CODE_40014("40014", "不合法的access_token"),
    ERROR_CODE_40016("40016", "不合法的按钮个数"),
    ERROR_CODE_40017("40017", "不合法的按钮类型"),
    ERROR_CODE_40018("40018", "不合法的按钮名字长度"),
    ERROR_CODE_40019("40019", "不合法的按钮KEY长度"),
    ERROR_CODE_40020("40020", "不合法的按钮URL长度"),
    ERROR_CODE_40022("40022", "不合法的子菜单级数"),
    ERROR_CODE_40023("40023", "不合法的子菜单按钮个数"),
    ERROR_CODE_40024("40024", "不合法的子菜单按钮类型"),
    ERROR_CODE_40025("40025", "不合法的子菜单按钮名字长度"),
    ERROR_CODE_40026("40026", "不合法的子菜单按钮KEY长度"),
    ERROR_CODE_40027("40027", "不合法的子菜单按钮URL长度"),
    ERROR_CODE_40029("40029", "不合法的oauth_code"),
    ERROR_CODE_40031("40031", "不合法的UserID列表"),
    ERROR_CODE_40032("40032", "不合法的UserID列表长度"),
    ERROR_CODE_40033("40033", "不合法的请求字符"),
    ERROR_CODE_40035("40035", "不合法的参数"),
    ERROR_CODE_40050("40050", "chatid不存在"),
    ERROR_CODE_40054("40054", "不合法的子菜单url域名"),
    ERROR_CODE_40055("40055", "不合法的菜单url域名"),
    ERROR_CODE_40056("40056", "不合法的agentid"),
    ERROR_CODE_40057("40057", "不合法的callbackurl或者callbackurl验证失败"),
    ERROR_CODE_40058("40058", "不合法的参数"),
    ERROR_CODE_40059("40059", "不合法的上报地理位置标志位"),
    ERROR_CODE_40063("40063", "参数为空"),
    ERROR_CODE_40066("40066", "不合法的部门列表"),
    ERROR_CODE_40068("40068", "不合法的标签ID"),
    ERROR_CODE_40070("40070", "指定的标签范围结点全部无效"),
    ERROR_CODE_40071("40071", "不合法的标签名字"),
    ERROR_CODE_40072("40072", "不合法的标签名字长度"),
    ERROR_CODE_40073("40073", "不合法的openid"),
    ERROR_CODE_40074("40074", "news消息不支持保密消息类型"),
    ERROR_CODE_40077("40077", "不合法的pre_auth_code参数"),
    ERROR_CODE_40078("40078", "不合法的auth_code参数"),
    ERROR_CODE_40080("40080", "不合法的suite_secret"),
    ERROR_CODE_40082("40082", "不合法的suite_token"),
    ERROR_CODE_40083("40083", "不合法的suite_id"),
    ERROR_CODE_40084("40084", "不合法的permanent_code参数"),
    ERROR_CODE_40085("40085", "不合法的的suite_ticket参数"),
    ERROR_CODE_40086("40086", "不合法的第三方应用appid"),
    ERROR_CODE_40088("40088", "jobid不存在"),
    ERROR_CODE_40089("40089", "批量任务的结果已清理"),
    ERROR_CODE_40091("40091", "secret不合法"),
    ERROR_CODE_40092("40092", "导入文件存在不合法的内容"),
    ERROR_CODE_40093("40093", "不合法的jsapi_ticket参数"),
    ERROR_CODE_40094("40094", "不合法的URL"),
    ERROR_CODE_40096("40096", "不合法的外部联系人userid"),
    ERROR_CODE_40097("40097", "该成员尚未离职"),
    ERROR_CODE_40098("40098", "接替成员尚未实名认证"),
    ERROR_CODE_40099("40099", "接替成员的外部联系人数量已达上限"),
    ERROR_CODE_40100("40100", "此用户的外部联系人已经在转移流程中"),
    ERROR_CODE_41001("41001", "缺少access_token参数"),
    ERROR_CODE_41002("41002", "缺少corpid参数"),
    ERROR_CODE_41004("41004", "缺少secret参数"),
    ERROR_CODE_41006("41006", "缺少media_id参数"),
    ERROR_CODE_41008("41008", "缺少auth code参数"),
    ERROR_CODE_41009("41009", "缺少userid参数"),
    ERROR_CODE_41010("41010", "缺少url参数"),
    ERROR_CODE_41011("41011", "缺少agentid参数"),
    ERROR_CODE_41033("41033", "缺少 description 参数"),
    ERROR_CODE_41035("41035", "缺少外部联系人userid参数"),
    ERROR_CODE_41016("41016", "缺少title参数"),
    ERROR_CODE_41019("41019", "缺少 department 参数"),
    ERROR_CODE_41017("41017", "缺少tagid参数"),
    ERROR_CODE_41021("41021", "缺少suite_id参数"),
    ERROR_CODE_41022("41022", "缺少suite_access_token参数"),
    ERROR_CODE_41023("41023", "缺少suite_ticket参数"),
    ERROR_CODE_41024("41024", "缺少secret参数"),
    ERROR_CODE_41025("41025", "缺少permanent_code参数"),
    ERROR_CODE_42001("42001", "access_token已过期"),
    ERROR_CODE_42007("42007", "pre_auth_code已过期"),
    ERROR_CODE_42009("42009", "suite_access_token已过期"),
    ERROR_CODE_43004("43004", "指定的userid未绑定微信或未关注微工作台（原企业号）"),
    ERROR_CODE_44001("44001", "多媒体文件为空"),
    ERROR_CODE_44004("44004", "文本消息content参数为空"),
    ERROR_CODE_45001("45001", "多媒体文件大小超过限制"),
    ERROR_CODE_45002("45002", "消息内容大小超过限制"),
    ERROR_CODE_45004("45004", "应用description参数长度不符合系统限制"),
    ERROR_CODE_45007("45007", "语音播放时间超过限制"),
    ERROR_CODE_45008("45008", "图文消息的文章数量不符合系统限制"),
    ERROR_CODE_45009("45009", "接口调用超过限制"),
    ERROR_CODE_45022("45022", "应用name参数长度不符合系统限制"),
    ERROR_CODE_45024("45024", "帐号数量超过上限"),
    ERROR_CODE_45026("45026", "触发删除用户数的保护"),
    ERROR_CODE_45032("45032", "图文消息author参数长度超过限制"),
    ERROR_CODE_45033("45033", "接口并发调用超过限制"),
    ERROR_CODE_46003("46003", "菜单未设置"),
    ERROR_CODE_46004("46004", "指定的用户不存在"),
    ERROR_CODE_48002("48002", "API接口无权限调用"),
    ERROR_CODE_48003("48003", "不合法的suite_id"),
    ERROR_CODE_48004("48004", "授权关系无效"),
    ERROR_CODE_48005("48005", "API接口已废弃"),
    ERROR_CODE_50001("50001", "redirect_url未登记可信域名"),
    ERROR_CODE_50002("50002", "成员不在权限范围"),
    ERROR_CODE_50003("50003", "应用已禁用"),
    ERROR_CODE_60001("60001", "部门长度不符合限制"),
    ERROR_CODE_60003("60003", "部门ID不存在"),
    ERROR_CODE_60004("60004", "父部门不存在"),
    ERROR_CODE_60005("60005", "部门下存在成员"),
    ERROR_CODE_60006("60006", "部门下存在子部门"),
    ERROR_CODE_60007("60007", "不允许删除根部门"),
    ERROR_CODE_60008("60008", "部门已存在"),
    ERROR_CODE_60009("60009", "部门名称含有非法字符"),
    ERROR_CODE_60010("60010", "部门存在循环关系"),
    ERROR_CODE_60011("60011", "指定的成员/部门/标签参数无权限"),
    ERROR_CODE_60012("60012", "不允许删除默认应用"),
    ERROR_CODE_60020("60020", "访问ip不在白名单之中"),
    ERROR_CODE_60028("60028", "不允许修改第三方应用的主页 URL"),
    ERROR_CODE_60102("60102", "UserID已存在"),
    ERROR_CODE_60103("60103", "手机号码不合法"),
    ERROR_CODE_60104("60104", "手机号码已存在"),
    ERROR_CODE_60105("60105", "邮箱不合法"),
    ERROR_CODE_60106("60106", "邮箱已存在"),
    ERROR_CODE_60107("60107", "微信号不合法"),
    ERROR_CODE_60110("60110", "用户所属部门数量超过限制"),
    ERROR_CODE_60111("60111", "UserID不存在"),
    ERROR_CODE_60112("60112", "成员name参数不合法"),
    ERROR_CODE_60123("60123", "无效的部门id"),
    ERROR_CODE_60124("60124", "无效的父部门id"),
    ERROR_CODE_60125("60125", "非法部门名字"),
    ERROR_CODE_60127("60127", "缺少department参数"),
    ERROR_CODE_60129("60129", "成员手机和邮箱都为空"),
    ERROR_CODE_72023("72023", "发票已被其他公众号锁定"),
    ERROR_CODE_72024("72024", "发票状态错误"),
    ERROR_CODE_72037("72037", "存在发票不属于该用户"),
    ERROR_CODE_80001("80001", "可信域名不正确，或者无ICP备案"),
    ERROR_CODE_81001("81001", "部门下的结点数超过限制（3W）"),
    ERROR_CODE_81002("81002", "部门最多15层"),
    ERROR_CODE_81011("81011", "无权限操作标签"),
    ERROR_CODE_81013("81013", "UserID、部门ID、标签ID全部非法或无权限"),
    ERROR_CODE_81014("81014", "标签添加成员，单次添加user或party过多"),
    ERROR_CODE_82001("82001", "指定的成员/部门/标签全部无效"),
    ERROR_CODE_82002("82002", "不合法的PartyID列表长度"),
    ERROR_CODE_82003("82003", "不合法的TagID列表长度"),
    ERROR_CODE_84014("84014", "成员票据过期"),
    ERROR_CODE_84015("84015", "成员票据无效"),
    ERROR_CODE_84019("84019", "缺少templateid参数"),
    ERROR_CODE_84020("84020", "templateid不存在"),
    ERROR_CODE_84021("84021", "缺少register_code参数"),
    ERROR_CODE_84022("84022", "无效的register_code参数"),
    ERROR_CODE_84023("84023", "不允许调用设置通讯录同步完成接口"),
    ERROR_CODE_84024("84024", "无注册信息"),
    ERROR_CODE_84025("84025", "不符合的state参数"),
    ERROR_CODE_84052("84052", "缺少caller参数"),
    ERROR_CODE_84053("84053", "缺少callee参数"),
    ERROR_CODE_84054("84054", "缺少auth_corpid参数"),
    ERROR_CODE_84055("84055", "超过拨打公费电话频率"),
    ERROR_CODE_84056("84056", "被拨打用户安装应用时未授权拨打公费电话权限"),
    ERROR_CODE_84057("84057", "公费电话余额不足"),
    ERROR_CODE_84058("84058", "caller 呼叫号码不支持"),
    ERROR_CODE_84059("84059", "号码非法"),
    ERROR_CODE_84060("84060", "callee 呼叫号码不支持"),
    ERROR_CODE_84061("84061", "不存在外部联系人的关系"),
    ERROR_CODE_84062("84062", "未开启公费电话应用"),
    ERROR_CODE_84063("84063", "caller不存在"),
    ERROR_CODE_84064("84064", "callee不存在"),
    ERROR_CODE_84065("84065", "caller跟callee电话号码一致"),
    ERROR_CODE_84071("84071", "不合法的外部联系人授权码"),
    ERROR_CODE_84072("84072", "应用未配置客服"),
    ERROR_CODE_84073("84073", "客服userid不在应用配置的客服列表中"),
    ERROR_CODE_84074("84074", "没有外部联系人权限"),
    ERROR_CODE_85002("85002", "包含不合法的词语"),
    ERROR_CODE_85004("85004", "每企业每个月设置的可信域名不可超过20个"),
    ERROR_CODE_85005("85005", "可信域名未通过所有权校验"),
    ERROR_CODE_86001("86001", "参数 chatid 不合法"),
    ERROR_CODE_86003("86003", "参数 chatid 不存在"),
    ERROR_CODE_86004("86004", "参数 群名不合法"),
    ERROR_CODE_86005("86005", "参数 群主不合法"),
    ERROR_CODE_86006("86006", "群成员数过多或过少"),
    ERROR_CODE_86007("86007", "不合法的群成员"),
    ERROR_CODE_86008("86008", "非法操作非自己创建的群"),
    ERROR_CODE_86215("86215", "会话ID已经存在"),
    ERROR_CODE_86216("86216", "存在非法会话成员ID"),
    ERROR_CODE_86217("86217", "会话发送者不在会话成员列表中"),
    ERROR_CODE_86220("86220", "指定的会话参数不合法"),
    ERROR_CODE_90001("90001", "未认证摇一摇周边"),
    ERROR_CODE_90002("90002", "缺少摇一摇周边ticket参数"),
    ERROR_CODE_90003("90003", "摇一摇周边ticket参数不合法"),
    ERROR_CODE_90100("90100", "非法的对外属性类型"),
    ERROR_CODE_90101("90101", "对外属性：文本类型长度不合法"),
    ERROR_CODE_90102("90102", "对外属性：网页类型标题长度不合法"),
    ERROR_CODE_90103("90103", "对外属性：网页url不合法"),
    ERROR_CODE_90104("90104", "对外属性：小程序类型标题长度不合法"),
    ERROR_CODE_90105("90105", "对外属性：小程序类型pagepath不合法"),
    ERROR_CODE_90106("90106", "对外属性：请求参数不合法"),
    ERROR_CODE_91040("91040", "获取ticket的类型无效"),
    ERROR_CODE_301002("301002", "无权限操作指定的应用"),
    ERROR_CODE_301005("301005", "不允许删除创建者"),
    ERROR_CODE_301012("301012", "参数 position 不合法"),
    ERROR_CODE_301013("301013", "参数 telephone 不合法"),
    ERROR_CODE_301014("301014", "参数 english_name 不合法"),
    ERROR_CODE_301015("301015", "参数 mediaid 不合法"),
    ERROR_CODE_301016("301016", "上传语音文件不符合系统要求"),
    ERROR_CODE_301017("301017", "上传语音文件仅支持AMR格式"),
    ERROR_CODE_301021("301021", "参数 userid 无效"),
    ERROR_CODE_301022("301022", "获取打卡数据失败"),
    ERROR_CODE_301023("301023", "useridlist非法或超过限额"),
    ERROR_CODE_301024("301024", "获取打卡记录时间间隔超限"),
    ERROR_CODE_301036("301036", "不允许更新该用户的userid"),
    ERROR_CODE_302003("302003", "批量导入任务的文件中userid有重复"),
    ERROR_CODE_302004("302004", "组织架构不合法（1不是一棵树，2 多个一样的partyid，3 partyid空，4 partyid name 空，5 同一个父节点下有两个子节点 部门名字一样 可能是以上情况，请一一排查）"),
    ERROR_CODE_302005("302005", "批量导入系统失败，请重新尝试导入"),
    ERROR_CODE_302006("302006", "批量导入任务的文件中partyid有重复"),
    ERROR_CODE_302007("302007", "批量导入任务的文件中，同一个部门下有两个子部门名字一样"),
    ERROR_CODE_2000002("2000002", "CorpId参数无效"),
    UNKNOWN("9999999", "未知异常");
    private final String errorCode;
    private final String errorDesc;

    ErrorCode(String errorCode, String errorDesc) {
        this.errorCode = errorCode;
        this.errorDesc = errorDesc;
    }

    public static String getErrorDesc(String errorCode) {
        for (ErrorCode wxErrorCodeEnum : values()) {
            if (Objects.equals(wxErrorCodeEnum.errorCode, errorCode)) {
                return wxErrorCodeEnum.errorDesc;
            }
        }
        return null;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public static ErrorCode errorCode(String code) {
        for (ErrorCode value : values()) {
            if (Objects.nonNull(code)) {
                if (value.getErrorCode().equals(code)) {
                    return value;
                }
            }
        }

        return UNKNOWN;
    }

    public String getErrorDesc() {
        return errorDesc;
    }
}
