/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.autoconfigure;

import com.github.shuaidd.client.config.WeChatConfigurationProperties;
import com.github.shuaidd.support.CallBackManager;
import com.github.shuaidd.support.WeChatContextHolder;
import com.github.shuaidd.support.WeChatManager;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"com.github.shuaidd.service", "com.github.shuaidd.support", "com.github.shuaidd.aspect"})
@EnableConfigurationProperties(value={WeChatConfigurationProperties.class})
public class WeChatAutoConfiguration
implements InitializingBean {
    private final WeChatConfigurationProperties properties;
    private final WeChatManager weChatManager;

    public WeChatAutoConfiguration(WeChatConfigurationProperties properties, WeChatManager weChatManager) {
        this.properties = properties;
        this.weChatManager = weChatManager;
    }

    @ConditionalOnMissingBean(value={CacheManager.class})
    @Bean
    public CacheManager cacheManager() {
        ConcurrentMapCacheManager concurrentMapCacheManager = new ConcurrentMapCacheManager();
        concurrentMapCacheManager.setAllowNullValues(true);
        concurrentMapCacheManager.setCacheNames(Collections.singletonList("qywx"));
        return concurrentMapCacheManager;
    }

    public void afterPropertiesSet() {
        CallBackManager.properties((List)this.properties.getCallbackList());
        WeChatContextHolder.setWeChatManager((WeChatManager)this.weChatManager);
    }
}

