/*
 * Decompiled with CFR 0.152.
 */
package cn.acooly.sdk.filecoin.transport;

import cn.acooly.sdk.filecoin.FilecoinSdkProperties;
import cn.acooly.sdk.filecoin.domain.JsonRpcError;
import cn.acooly.sdk.filecoin.domain.JsonRpcRequest;
import cn.acooly.sdk.filecoin.domain.JsonRpcResponse;
import cn.acooly.sdk.filecoin.transport.JsonRpcTransport;
import com.acooly.core.common.exception.BusinessException;
import com.acooly.core.common.exception.CommonErrorCodes;
import com.acooly.core.utils.Reflections;
import com.acooly.core.utils.Strings;
import com.acooly.core.utils.enums.Messageable;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.kevinsawicki.http.HttpRequest;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

@Component
public class JsonRpcHttpTransport
implements JsonRpcTransport {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcHttpTransport.class);
    @Autowired
    private FilecoinSdkProperties filecoinSdkProperties;

    public JsonRpcHttpTransport() {
    }

    public JsonRpcHttpTransport(FilecoinSdkProperties filecoinSdkProperties) {
        this.filecoinSdkProperties = filecoinSdkProperties;
    }

    @Override
    public <T extends JsonRpcResponse> T send(JsonRpcRequest request, Class<T> responseClass) {
        FilecoinSdkProperties.Gateway g = this.filecoinSdkProperties.getGateway();
        this.prevHandleRequest(request);
        String requestBody = this.toJson(request);
        log.info("Requ-Body {} : {}", (Object)request.getMethod(), (Object)requestBody);
        String responseBody = null;
        try {
            HttpRequest httpRequest = HttpRequest.post((CharSequence)g.getUrl()).contentType("application/json").authorization("Bearer " + g.getToken()).connectTimeout(g.getConnTimeout() * 1000).readTimeout(g.getReadTimeout() * 1000).send((CharSequence)this.toJson(request));
            responseBody = httpRequest.body();
            log.info("Resp-Body {} : {}", (Object)request.getMethod(), (Object)Strings.trimToEmpty((String)responseBody));
        }
        catch (Exception e) {
            throw new BusinessException((Messageable)CommonErrorCodes.COMMUNICATION_ERROR, (Throwable)e);
        }
        return (T)this.fromJson(responseBody, responseClass);
    }

    protected void prevHandleRequest(JsonRpcRequest request) {
        if (request.getId() == null) {
            request.setId(RandomUtils.nextLong());
        }
    }

    protected String toJson(JsonRpcRequest request) {
        return JSON.toJSONString((Object)request);
    }

    protected JsonRpcResponse fromJson(String json, Class clazz) {
        Object resultObject;
        JsonRpcResponse jsonRpcResponse = (JsonRpcResponse)Reflections.createObject((Class)clazz, (Object[])new Object[0]);
        JSONObject jsonObject = JSON.parseObject((String)json);
        JSONObject error = jsonObject.getJSONObject("error");
        if (error != null) {
            jsonRpcResponse.setError(error.toJSONString());
            jsonRpcResponse.setErrorObject((JsonRpcError)error.toJavaObject(JsonRpcError.class));
        }
        if ((resultObject = jsonObject.get((Object)"result")) != null) {
            if (JSONObject.class.isAssignableFrom(resultObject.getClass()) || JSONArray.class.isAssignableFrom(resultObject.getClass())) {
                JSON result = (JSON)resultObject;
                jsonRpcResponse.setResult(result.toJSONString());
                Class resultClass = JsonRpcHttpTransport.getGenericClass(clazz, 0);
                if (resultClass != null) {
                    jsonRpcResponse.convertAndSetResult(result.toJavaObject(resultClass));
                }
            } else {
                jsonRpcResponse.setResult(String.valueOf(resultObject));
                jsonRpcResponse.setResultObject(resultObject);
            }
        }
        jsonRpcResponse.setId(jsonObject.getString("id"));
        jsonRpcResponse.setJsonrpc(jsonObject.getString("jsonrpc"));
        return jsonRpcResponse;
    }

    public static Class getGenericClass(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (genType instanceof ParameterizedType) {
            Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
            if (params == null || params.length < index - 1) {
                return null;
            }
            if (params[index] instanceof ParameterizedTypeImpl) {
                ParameterizedTypeImpl ptl = (ParameterizedTypeImpl)params[index];
                return ptl.getRawType();
            }
            return (Class)params[index];
        }
        return null;
    }
}

