/*
 * Decompiled with CFR 0.152.
 */
package cn.acooly.sdk.filecoin.rpclient;

import cn.acooly.sdk.filecoin.domain.FilMessage;
import cn.acooly.sdk.filecoin.domain.FilSignMessage;
import cn.acooly.sdk.filecoin.domain.JsonRpcRequest;
import cn.acooly.sdk.filecoin.domain.JsonRpcResponse;
import cn.acooly.sdk.filecoin.enums.KeyType;
import cn.acooly.sdk.filecoin.rpclient.AbstractFileCoinRpcApiClient;
import cn.acooly.sdk.filecoin.rpclient.message.FilSignMessageResponse;
import cn.acooly.sdk.filecoin.rpclient.message.WalletListRpcResponse;
import cn.acooly.sdk.filecoin.transport.JsonRpcTransport;
import com.acooly.core.common.exception.BusinessException;
import com.acooly.core.utils.Strings;
import com.acooly.core.utils.enums.Messageable;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCoinWallet
extends AbstractFileCoinRpcApiClient {
    private static final Logger log = LoggerFactory.getLogger(FileCoinWallet.class);

    public String walletNew(KeyType keyType) {
        JsonRpcRequest request = new JsonRpcRequest();
        request.setMethod("Filecoin.WalletNew");
        request.addParam(keyType.code());
        JsonRpcResponse response = this.jsonRpcTransport.send(request, JsonRpcResponse.class);
        if (response.isSuccess()) {
            return response.getResult();
        }
        throw new BusinessException((Messageable)response.getErrorObject(), response.getErrorObject().getData());
    }

    public List<String> walletList() {
        JsonRpcRequest request = new JsonRpcRequest();
        request.setMethod("Filecoin.WalletList");
        WalletListRpcResponse response = this.jsonRpcTransport.send(request, WalletListRpcResponse.class);
        if (response.isSuccess()) {
            return (List)response.getResultObject();
        }
        throw new BusinessException((Messageable)response.getErrorObject(), response.getErrorObject().getData());
    }

    public BigDecimal walletBalance(String address) {
        String balanceResult;
        JsonRpcRequest request = new JsonRpcRequest("Filecoin.WalletBalance");
        request.addParam(address);
        JsonRpcResponse response = this.jsonRpcTransport.send(request, JsonRpcResponse.class);
        if (response.isSuccess() && Strings.isNumber((CharSequence)(balanceResult = response.getResult()))) {
            BigDecimal bigDecimal = new BigDecimal(balanceResult);
            if (bigDecimal.equals(BigDecimal.ZERO)) {
                return bigDecimal;
            }
            BigDecimal balance = bigDecimal.divide(new BigDecimal(Math.pow(10.0, 18.0)), 8, 4);
            return balance;
        }
        throw new BusinessException((Messageable)response.getErrorObject(), response.getErrorObject().getData());
    }

    public FilSignMessage walletSignMessage(FilMessage filMessage) {
        JsonRpcRequest request = new JsonRpcRequest("Filecoin.WalletSignMessage");
        request.addParam(filMessage.getFrom());
        request.addParam(filMessage);
        FilSignMessageResponse response = this.jsonRpcTransport.send(request, FilSignMessageResponse.class);
        if (response.isSuccess()) {
            return (FilSignMessage)response.getResultObject();
        }
        throw new BusinessException((Messageable)response.getErrorObject(), response.getErrorObject().getData());
    }

    public FileCoinWallet() {
    }

    public FileCoinWallet(JsonRpcTransport jsonRpcTransport) {
        super(jsonRpcTransport);
    }
}

