/*
 * Decompiled with CFR 0.152.
 */
package cn.acooly.sdk.filecoin.rpclient;

import cn.acooly.sdk.filecoin.domain.FilMessage;
import cn.acooly.sdk.filecoin.domain.FilSignMessage;
import cn.acooly.sdk.filecoin.domain.JsonRpcRequest;
import cn.acooly.sdk.filecoin.domain.JsonRpcResponse;
import cn.acooly.sdk.filecoin.rpclient.AbstractFileCoinRpcApiClient;
import cn.acooly.sdk.filecoin.rpclient.message.FilSignMessageResponse;
import cn.acooly.sdk.filecoin.transport.JsonRpcTransport;
import com.acooly.core.common.exception.BusinessException;
import com.acooly.core.utils.enums.Messageable;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCoinMpool
extends AbstractFileCoinRpcApiClient {
    private static final Logger log = LoggerFactory.getLogger(FileCoinMpool.class);

    public Integer mpoolGetNonce(String address) {
        JsonRpcRequest request = new JsonRpcRequest("Filecoin.MpoolGetNonce");
        request.addParam(address);
        JsonRpcResponse response = this.jsonRpcTransport.send(request, JsonRpcResponse.class);
        if (response.isSuccess()) {
            return (Integer)response.getResultObject();
        }
        throw new BusinessException((Messageable)response.getErrorObject(), response.getErrorObject().getData());
    }

    public FilSignMessage mpoolPushMessage(FilMessage filMessage) {
        JsonRpcRequest request = new JsonRpcRequest("Filecoin.MpoolPushMessage");
        request.addParam(filMessage);
        HashMap map = Maps.newHashMap();
        map.put("MaxFee", "0");
        request.addParam(map);
        FilSignMessageResponse response = this.jsonRpcTransport.send(request, FilSignMessageResponse.class);
        if (response.isSuccess()) {
            return (FilSignMessage)response.getResultObject();
        }
        throw new BusinessException((Messageable)response.getErrorObject(), response.getErrorObject().getData());
    }

    public String mpoolPush(FilSignMessage filSignMessage) {
        JsonRpcRequest request = new JsonRpcRequest("Filecoin.MpoolPush");
        request.addParam(filSignMessage);
        FilSignMessageResponse response = this.jsonRpcTransport.send(request, FilSignMessageResponse.class);
        if (response.isSuccess()) {
            JSONObject jsonObject = JSON.parseObject((String)response.getResult());
            return jsonObject.getString("/");
        }
        throw new BusinessException((Messageable)response.getErrorObject(), response.getErrorObject().getData());
    }

    public FileCoinMpool() {
    }

    public FileCoinMpool(JsonRpcTransport jsonRpcTransport) {
        super(jsonRpcTransport);
    }
}

