/*
 * Decompiled with CFR 0.152.
 */
package cn.acooly.sdk.filecoin.rpclient;

import cn.acooly.sdk.filecoin.domain.FilMessage;
import cn.acooly.sdk.filecoin.domain.JsonRpcRequest;
import cn.acooly.sdk.filecoin.domain.JsonRpcResponse;
import cn.acooly.sdk.filecoin.rpclient.AbstractFileCoinRpcApiClient;
import cn.acooly.sdk.filecoin.transport.JsonRpcTransport;
import com.acooly.core.common.exception.BusinessException;
import com.acooly.core.utils.enums.Messageable;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCoinGas
extends AbstractFileCoinRpcApiClient {
    private static final Logger log = LoggerFactory.getLogger(FileCoinGas.class);

    public String gasEstimateFeeCap(FilMessage message) {
        JsonRpcRequest request = new JsonRpcRequest("Filecoin.GasEstimateFeeCap");
        request.addParam(message);
        request.addParam(100);
        request.addParam(null);
        JsonRpcResponse response = this.jsonRpcTransport.send(request, JsonRpcResponse.class);
        if (response.isSuccess()) {
            String result = response.getResult();
            return result;
        }
        throw new BusinessException((Messageable)response.getErrorObject(), response.getErrorObject().getData());
    }

    public BigInteger gasEstimateGasLimit(FilMessage message) {
        JsonRpcRequest request = new JsonRpcRequest("Filecoin.GasEstimateGasLimit");
        request.addParam(message);
        request.addParam(null);
        JsonRpcResponse response = this.jsonRpcTransport.send(request, JsonRpcResponse.class);
        if (response.isSuccess()) {
            String result = response.getResult();
            return new BigInteger(result);
        }
        throw new BusinessException((Messageable)response.getErrorObject(), response.getErrorObject().getData());
    }

    public FileCoinGas() {
    }

    public FileCoinGas(JsonRpcTransport jsonRpcTransport) {
        super(jsonRpcTransport);
    }
}

