/*
 * Decompiled with CFR 0.152.
 */
package cn.acooly.sdk.filecoin.rpclient;

import cn.acooly.sdk.filecoin.domain.JsonRpcRequest;
import cn.acooly.sdk.filecoin.domain.JsonRpcResponse;
import cn.acooly.sdk.filecoin.rpclient.AbstractFileCoinRpcApiClient;
import cn.acooly.sdk.filecoin.rpclient.message.ChainGetBlockMessagesRpcResponse;
import cn.acooly.sdk.filecoin.rpclient.message.ChainGetTipSetByHeightRpcResponse;
import cn.acooly.sdk.filecoin.transport.JsonRpcTransport;
import com.acooly.core.common.exception.BusinessException;
import com.acooly.core.utils.Collections3;
import com.acooly.core.utils.enums.Messageable;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCoinChain
extends AbstractFileCoinRpcApiClient {
    private static final Logger log = LoggerFactory.getLogger(FileCoinChain.class);

    public Integer getBlockHeight() {
        JsonRpcRequest request = new JsonRpcRequest("Filecoin.ChainHead");
        JsonRpcResponse response = this.jsonRpcTransport.send(request, JsonRpcResponse.class);
        if (response.isSuccess()) {
            JSONObject object = JSONObject.parseObject((String)response.getResult());
            if (object != null) {
                return object.getInteger("Height");
            }
            return 0;
        }
        throw new BusinessException((Messageable)response.getErrorObject(), response.getErrorObject().getData());
    }

    public ChainGetTipSetByHeightRpcResponse.ChainGetTipSetByHeight chainGetTipSetByHeight(Integer blockHeight) {
        ArrayList params = Lists.newArrayList();
        params.add(blockHeight);
        params.add(Lists.newArrayList());
        JsonRpcRequest request = new JsonRpcRequest("Filecoin.ChainGetTipSetByHeight", params);
        ChainGetTipSetByHeightRpcResponse response = this.jsonRpcTransport.send(request, ChainGetTipSetByHeightRpcResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException((Messageable)response.getErrorObject(), response.getErrorObject().getData());
        }
        ChainGetTipSetByHeightRpcResponse.ChainGetTipSetByHeight chainGetTipSetByHeight = (ChainGetTipSetByHeightRpcResponse.ChainGetTipSetByHeight)response.getResultObject();
        JSONObject jsonObject = JSON.parseObject((String)response.getResult());
        JSONArray jsonArray = jsonObject.getJSONArray("Cids");
        if (Collections3.isNotEmpty((Collection)jsonArray)) {
            for (Object o : jsonArray) {
                JSONObject cid = (JSONObject)o;
                chainGetTipSetByHeight.getFilCids().add(cid.getString("/"));
            }
        }
        return chainGetTipSetByHeight;
    }

    public ChainGetBlockMessagesRpcResponse.ChainGetBlockMessages chainGetBlockMessages(String cid) {
        ArrayList params = Lists.newArrayList();
        HashMap param = Maps.newHashMap();
        param.put("/", cid);
        params.add(param);
        JsonRpcRequest request = new JsonRpcRequest("Filecoin.ChainGetBlockMessages", params);
        ChainGetBlockMessagesRpcResponse response = this.jsonRpcTransport.send(request, ChainGetBlockMessagesRpcResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException((Messageable)response.getErrorObject(), response.getErrorObject().getData());
        }
        return (ChainGetBlockMessagesRpcResponse.ChainGetBlockMessages)response.getResultObject();
    }

    public FileCoinChain() {
    }

    public FileCoinChain(JsonRpcTransport jsonRpcTransport) {
        super(jsonRpcTransport);
    }
}

