/*
 * Decompiled with CFR 0.152.
 */
package cn.acooly.sdk.filecoin.enums;

import com.acooly.core.utils.enums.Messageable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public enum KeyType implements Messageable
{
    secp256k1("secp256k1", "\u692d\u5706\u66f2\u7ebf\u6570\u5b57\u7b7e\u540d"),
    secp256k1_ledger("secp256k1-ledger", "secp256k1-ledger"),
    bls("bls", "bls");

    private final String code;
    private final String message;

    private KeyType(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public static Map<String, String> mapping() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (KeyType type : KeyType.values()) {
            map.put(type.getCode(), type.getMessage());
        }
        return map;
    }

    public static KeyType find(String code) {
        for (KeyType status : KeyType.values()) {
            if (!status.getCode().equals(code)) continue;
            return status;
        }
        return null;
    }

    public static List<KeyType> getAll() {
        ArrayList<KeyType> list = new ArrayList<KeyType>();
        for (KeyType status : KeyType.values()) {
            list.add(status);
        }
        return list;
    }

    public static List<String> getAllCode() {
        ArrayList<String> list = new ArrayList<String>();
        for (KeyType status : KeyType.values()) {
            list.add(status.code());
        }
        return list;
    }
}

