/*
 * Decompiled with CFR 0.152.
 */
package cn.acooly.sdk.filecoin.domain;

import cn.acooly.sdk.filecoin.utils.FilecoinUtils;
import com.acooly.core.utils.BigMoney;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Maps;
import java.util.Map;

public class FilMessage {
    @JSONField(name="Version")
    private int version = 0;
    @JSONField(name="To")
    private String to;
    @JSONField(name="From")
    private String from;
    @JSONField(name="Nonce")
    private int nonce = 0;
    @JSONField(name="Value")
    private String value;
    @JSONField(name="GasLimit")
    private int gasLimit = 0;
    @JSONField(name="GasFeeCap")
    private String gasFeeCap = "0";
    @JSONField(name="GasPremium")
    private String gasPremium = "0";
    @JSONField(name="Method")
    private int method = 0;
    @JSONField(name="Params")
    private String params;
    @JSONField(name="CID")
    private Map<String, String> cids = Maps.newHashMap();

    @JSONField(serialize=false)
    public String getCID() {
        return this.cids.get("/");
    }

    @JSONField(deserialize=false)
    private void setCID(String cid) {
        this.cids.put("/", cid);
    }

    public BigMoney getAmount() {
        return FilecoinUtils.toBigMoney(this.value);
    }

    public FilMessage(String from, String to, String value, String params) {
        this.to = to;
        this.from = from;
        this.value = value;
        this.params = params;
    }

    public FilMessage(String from, String to, String value) {
        this(from, to, value, null);
    }

    public int getVersion() {
        return this.version;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public int getNonce() {
        return this.nonce;
    }

    public String getValue() {
        return this.value;
    }

    public int getGasLimit() {
        return this.gasLimit;
    }

    public String getGasFeeCap() {
        return this.gasFeeCap;
    }

    public String getGasPremium() {
        return this.gasPremium;
    }

    public int getMethod() {
        return this.method;
    }

    public String getParams() {
        return this.params;
    }

    public Map<String, String> getCids() {
        return this.cids;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setNonce(int nonce) {
        this.nonce = nonce;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setGasLimit(int gasLimit) {
        this.gasLimit = gasLimit;
    }

    public void setGasFeeCap(String gasFeeCap) {
        this.gasFeeCap = gasFeeCap;
    }

    public void setGasPremium(String gasPremium) {
        this.gasPremium = gasPremium;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setCids(Map<String, String> cids) {
        this.cids = cids;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilMessage)) {
            return false;
        }
        FilMessage other = (FilMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getNonce() != other.getNonce()) {
            return false;
        }
        if (this.getGasLimit() != other.getGasLimit()) {
            return false;
        }
        if (this.getMethod() != other.getMethod()) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$gasFeeCap = this.getGasFeeCap();
        String other$gasFeeCap = other.getGasFeeCap();
        if (this$gasFeeCap == null ? other$gasFeeCap != null : !this$gasFeeCap.equals(other$gasFeeCap)) {
            return false;
        }
        String this$gasPremium = this.getGasPremium();
        String other$gasPremium = other.getGasPremium();
        if (this$gasPremium == null ? other$gasPremium != null : !this$gasPremium.equals(other$gasPremium)) {
            return false;
        }
        String this$params = this.getParams();
        String other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        Map<String, String> this$cids = this.getCids();
        Map<String, String> other$cids = other.getCids();
        return !(this$cids == null ? other$cids != null : !((Object)this$cids).equals(other$cids));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        result = result * 59 + this.getNonce();
        result = result * 59 + this.getGasLimit();
        result = result * 59 + this.getMethod();
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $gasFeeCap = this.getGasFeeCap();
        result = result * 59 + ($gasFeeCap == null ? 43 : $gasFeeCap.hashCode());
        String $gasPremium = this.getGasPremium();
        result = result * 59 + ($gasPremium == null ? 43 : $gasPremium.hashCode());
        String $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        Map<String, String> $cids = this.getCids();
        result = result * 59 + ($cids == null ? 43 : ((Object)$cids).hashCode());
        return result;
    }

    public String toString() {
        return "FilMessage(version=" + this.getVersion() + ", to=" + this.getTo() + ", from=" + this.getFrom() + ", nonce=" + this.getNonce() + ", value=" + this.getValue() + ", gasLimit=" + this.getGasLimit() + ", gasFeeCap=" + this.getGasFeeCap() + ", gasPremium=" + this.getGasPremium() + ", method=" + this.getMethod() + ", params=" + this.getParams() + ", cids=" + this.getCids() + ")";
    }

    public FilMessage() {
    }
}

