/**
 * acooly-sdk-parent
 * <p>
 * Copyright 2014 Acooly.cn, Inc. All rights reserved.
 *
 * @author zhangpu
 * @date 2021-05-31 01:45
 */
package cn.acooly.sdk.exchangerate.enums;
/**
 * @author zhangpu
 * @date 2021-05-31 01:45
 */

import com.acooly.core.utils.enums.Messageable;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public enum ExchangeRateProvider implements Messageable {
    ExchangeRatesOrg("ExchangeRatesOrg", "世界货币汇率组织");

    private final String code;
    private final String message;

    ExchangeRateProvider(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    @Override
    public String code() {
        return code;
    }

    @Override
    public String message() {
        return message;
    }

    public static Map<String, String> mapping() {
        Map<String, String> map = new LinkedHashMap<String, String>();
        for (ExchangeRateProvider type : values()) {
            map.put(type.getCode(), type.getMessage());
        }
        return map;
    }

    /**
     * 通过枚举值码查找枚举值。
     *
     * @param code 查找枚举值的枚举值码。
     * @return 枚举值码对应的枚举值。
     * @throws IllegalArgumentException 如果 code 没有对应的 Status 。
     */
    public static ExchangeRateProvider find(String code) {
        for (ExchangeRateProvider status : values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    /**
     * 获取全部枚举值。
     *
     * @return 全部枚举值。
     */
    public static List<ExchangeRateProvider> getAll() {
        List<ExchangeRateProvider> list = new ArrayList<ExchangeRateProvider>();
        for (ExchangeRateProvider status : values()) {
            list.add(status);
        }
        return list;
    }

    /**
     * 获取全部枚举值码。
     *
     * @return 全部枚举值码。
     */
    public static List<String> getAllCode() {
        List<String> list = new ArrayList<String>();
        for (ExchangeRateProvider status : values()) {
            list.add(status.code());
        }
        return list;
    }

}
