/*
 * Decompiled with CFR 0.152.
 */
package cn.acmsmu.mgsky1.quartz.runner;

import cn.acmsmu.mgsky1.quartz.annotation.QuartzClient;
import cn.acmsmu.mgsky1.quartz.config.QuartzStarterConfig;
import cn.acmsmu.mgsky1.quartz.handler.StandaloneHandler;
import cn.acmsmu.mgsky1.quartz.meta.ClientTypeEnum;
import cn.acmsmu.mgsky1.quartz.model.QuartzHttpInvokerModel;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.ClassScanner;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class QuartzClientRunner
implements ApplicationRunner {
    private static final Logger logger = LoggerFactory.getLogger(QuartzClientRunner.class);
    private static final String LOGGER_PREFIX = "\u3010quartz-client\u3011";
    private static final Integer DEFAULT_PORT = 9100;
    @Autowired
    private QuartzStarterConfig starterConfig;
    @Autowired
    private ApplicationContext applicationContext;
    private ChannelFuture channelFuture = null;
    private EventLoopGroup bossGroup = null;
    private EventLoopGroup workerGroup = null;

    public void run(ApplicationArguments args) throws Exception {
        if (!ClientTypeEnum.STANDALONE.equalByCode(this.starterConfig.getType()).booleanValue()) {
            logger.error("{}: \u6682\u65f6\u4e0d\u652f\u6301\u5176\u4ed6\u6a21\u5f0f", (Object)LOGGER_PREFIX);
            return;
        }
        logger.info("{}: \u5b9a\u65f6\u4efb\u52a1\u914d\u7f6e\u4e3a:{}", (Object)LOGGER_PREFIX, JSON.toJSON((Object)this.starterConfig));
        ServerBootstrap serverBootstrap = this.initNettyServerBootStrap();
        final List<QuartzHttpInvokerModel> invokerModels = this.getTargetInvokerModel(this.starterConfig.getPackageScan());
        if (CollUtil.isEmpty(invokerModels)) {
            return;
        }
        serverBootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast("httpAggregator", (ChannelHandler)new HttpObjectAggregator(0x6400000));
                pipeline.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
                if (CollUtil.isNotEmpty((Collection)invokerModels)) {
                    pipeline.addLast(new ChannelHandler[]{new StandaloneHandler(invokerModels)});
                }
            }
        });
        this.channelFuture = serverBootstrap.bind(Optional.ofNullable(this.starterConfig.getPort()).orElse(DEFAULT_PORT).intValue()).sync();
        logger.info("{}: \u5b9a\u65f6\u4efb\u52a1\u521d\u59cb\u5316\u5b8c\u6bd5", (Object)LOGGER_PREFIX);
    }

    private List<QuartzHttpInvokerModel> getTargetInvokerModel(String packageName) throws Exception {
        if (StrUtil.isEmpty((CharSequence)packageName)) {
            return Collections.emptyList();
        }
        logger.info("{}: \u8981\u626b\u63cf\u7684\u5b9a\u65f6\u4efb\u52a1\u7684\u5305\u540d\u4e3a\uff1a{}", (Object)LOGGER_PREFIX, (Object)packageName);
        ArrayList<QuartzHttpInvokerModel> quartzHttpInvokerModels = new ArrayList<QuartzHttpInvokerModel>();
        try {
            Set classes = ClassScanner.scanPackage((String)packageName);
            if (CollUtil.isNotEmpty((Collection)classes)) {
                for (Class clazz : classes) {
                    List<QuartzHttpInvokerModel> mList = this.getTargetInvokerModel(clazz);
                    if (!CollUtil.isNotEmpty(mList)) continue;
                    quartzHttpInvokerModels.addAll(mList);
                }
            }
            return quartzHttpInvokerModels;
        }
        catch (Exception e) {
            logger.error("{}: \u521d\u59cb\u5316\u65f6\u53d1\u751f\u5f02\u5e38:", (Object)LOGGER_PREFIX, (Object)e);
            throw e;
        }
    }

    private List<QuartzHttpInvokerModel> getTargetInvokerModel(Class clazz) {
        Method[] publicMethods = ReflectUtil.getPublicMethods((Class)clazz);
        if (publicMethods.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<QuartzHttpInvokerModel> methodList = new ArrayList<QuartzHttpInvokerModel>();
        for (Method method : publicMethods) {
            QuartzClient annotation = method.getAnnotation(QuartzClient.class);
            Integer parameterCount = method.getParameterCount();
            if (annotation == null || parameterCount != 1 && parameterCount != 0) continue;
            Object obj = this.applicationContext.getBean(clazz);
            methodList.add(new QuartzHttpInvokerModel("/" + annotation.value(), obj, method));
            logger.info("{}: \u626b\u63cf\u5230\u5b9a\u65f6\u4efb\u52a1\uff1a{}", (Object)LOGGER_PREFIX, (Object)annotation.value());
        }
        return methodList;
    }

    private ServerBootstrap initNettyServerBootStrap() {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        return serverBootstrap;
    }

    @PreDestroy
    public void destroy() throws Exception {
        if (this.channelFuture != null) {
            this.channelFuture.channel().closeFuture().sync();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
    }
}

