/*
 * Decompiled with CFR 0.152.
 */
package cn.acmsmu.mgsky1.quartz.handler;

import cn.acmsmu.mgsky1.quartz.model.QuartzHttpInvokerModel;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StandaloneHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private Map<String, QuartzHttpInvokerModel> invokerModelMap;

    public StandaloneHandler(List<QuartzHttpInvokerModel> modelList) {
        this.invokerModelMap = CollUtil.toMap(modelList, new HashMap(), QuartzHttpInvokerModel::getPath);
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        String url = request.uri();
        QuartzHttpInvokerModel model = this.invokerModelMap.get(url);
        if (model != null) {
            String body = request.content().toString(CharsetUtil.UTF_8);
            String m = request.method().name();
            if (!"POST".equals(m.toUpperCase())) {
                this.responseError(ctx);
                return;
            }
            if (JSONUtil.isJsonObj((String)body) || NumberUtil.isNumber((CharSequence)body)) {
                Method method = model.getMethod();
                Object p = null;
                if (method.getParameterCount() != 0) {
                    p = JSON.parseObject((String)body, method.getParameters()[0].getType());
                }
                Object obj = model.getObj();
                Object result = ReflectUtil.invoke((Object)obj, (Method)method, (Object[])new Object[]{p});
                this.responseOK(ctx, JSON.toJSONString((Object)result));
            } else {
                this.responseError(ctx);
            }
        } else {
            this.responseError(ctx);
        }
    }

    private void responseOK(ChannelHandlerContext ctx, String result) {
        this.response(ctx, "{\"status\":\"OK\", \"data\":" + result + "}");
    }

    private void responseError(ChannelHandlerContext ctx) {
        this.response(ctx, "{\"status\":\"Error\"}");
    }

    private void response(ChannelHandlerContext ctx, String result) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])result.getBytes()));
        response.headers().set("Content-Type", (Object)"application/json; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

