/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.AbstractTyme;
import com.tyme.rabbyung.RabByungYear;
import com.tyme.solar.SolarHalfYear;
import com.tyme.solar.SolarMonth;
import com.tyme.solar.SolarSeason;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0003J\u0006\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0016J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0013\u0010\u0017\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/tyme/solar/SolarYear;", "Lcom/tyme/AbstractTyme;", "year", "", "<init>", "(I)V", "getYear", "getDayCount", "isLeap", "", "getName", "", "next", "n", "getMonths", "", "Lcom/tyme/solar/SolarMonth;", "getSeasons", "Lcom/tyme/solar/SolarSeason;", "getHalfYears", "Lcom/tyme/solar/SolarHalfYear;", "getRabByungYear", "Lcom/tyme/rabbyung/RabByungYear;", "equals", "other", "", "hashCode", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nSolarYear.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolarYear.kt\ncom/tyme/solar/SolarYear\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class SolarYear
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int year;

    public SolarYear(int year) {
        this.year = year;
        int n = this.year;
        if (!(1 <= n ? n < 10000 : false)) {
            boolean bl = false;
            String string = "illegal solar year: " + this.year;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getYear() {
        return this.year;
    }

    public final int getDayCount() {
        if (1582 == this.year) {
            return 355;
        }
        return this.isLeap() ? 366 : 365;
    }

    public final boolean isLeap() {
        if (this.year < 1600) {
            return this.year % 4 == 0;
        }
        return this.year % 4 == 0 && this.year % 100 != 0 || this.year % 400 == 0;
    }

    @Override
    @NotNull
    public String getName() {
        return this.year + "\u5e74";
    }

    @Override
    @NotNull
    public SolarYear next(int n) {
        return new SolarYear(this.year + n);
    }

    @NotNull
    public final List<SolarMonth> getMonths() {
        List l = new ArrayList(12);
        for (int i = 1; i < 13; ++i) {
            l.add(new SolarMonth(this.year, i));
        }
        return l;
    }

    @NotNull
    public final List<SolarSeason> getSeasons() {
        List l = new ArrayList(4);
        for (int i = 0; i < 4; ++i) {
            l.add(new SolarSeason(this.year, i));
        }
        return l;
    }

    @NotNull
    public final List<SolarHalfYear> getHalfYears() {
        List l = new ArrayList(2);
        for (int i = 0; i < 2; ++i) {
            l.add(new SolarHalfYear(this.year, i));
        }
        return l;
    }

    @NotNull
    public final RabByungYear getRabByungYear() {
        return RabByungYear.Companion.fromYear(this.year);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SolarYear && Intrinsics.areEqual((Object)this.toString(), (Object)((SolarYear)other).toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final SolarYear fromYear(int year) {
        return Companion.fromYear(year);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/tyme/solar/SolarYear$Companion;", "", "<init>", "()V", "fromYear", "Lcom/tyme/solar/SolarYear;", "year", "", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SolarYear fromYear(int year) {
            return new SolarYear(year);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

