/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.AbstractTyme;
import com.tyme.culture.Week;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarMonth;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/tyme/solar/SolarWeek;", "Lcom/tyme/AbstractTyme;", "year", "", "month", "index", "start", "<init>", "(IIII)V", "Lcom/tyme/solar/SolarMonth;", "Lcom/tyme/culture/Week;", "getSolarMonth", "getYear", "getMonth", "getIndex", "getIndexInYear", "getStart", "getName", "", "toString", "next", "n", "getFirstDay", "Lcom/tyme/solar/SolarDay;", "getDays", "", "equals", "", "other", "", "hashCode", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nSolarWeek.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolarWeek.kt\ncom/tyme/solar/SolarWeek\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public final class SolarWeek
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int index;
    @NotNull
    private SolarMonth month;
    @NotNull
    private Week start;
    @NotNull
    private static final String[] NAMES;

    public SolarWeek(int year, int month, int index, int start) {
        this.index = index;
        int n = this.index;
        if (!(0 <= n ? n < 6 : false)) {
            boolean $i$a$-require-SolarWeek$42 = false;
            String $i$a$-require-SolarWeek$42 = "illegal solar week index: " + this.index;
            throw new IllegalArgumentException($i$a$-require-SolarWeek$42.toString());
        }
        if (!(0 <= start ? start < 7 : false)) {
            boolean bl = false;
            String string = "illegal solar week start: " + start;
            throw new IllegalArgumentException(string.toString());
        }
        SolarMonth m = new SolarMonth(year, month);
        if (!(this.index < m.getWeekCount(start))) {
            boolean bl = false;
            String string = "illegal solar week index: " + this.index + " in month: " + m;
            throw new IllegalArgumentException(string.toString());
        }
        this.month = m;
        this.start = new Week(start);
    }

    @NotNull
    public final SolarMonth getSolarMonth() {
        return this.month;
    }

    public final int getYear() {
        return this.month.getYear();
    }

    public final int getMonth() {
        return this.month.getMonth();
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getIndexInYear() {
        int i = 0;
        SolarDay firstDay = this.getFirstDay();
        SolarWeek w = new SolarWeek(this.getYear(), 1, 0, this.start.getIndex());
        while (!Intrinsics.areEqual((Object)w.getFirstDay(), (Object)firstDay)) {
            w = w.next(1);
            ++i;
        }
        return i;
    }

    @NotNull
    public final Week getStart() {
        return this.start;
    }

    @Override
    @NotNull
    public String getName() {
        return NAMES[this.index];
    }

    @Override
    @NotNull
    public String toString() {
        return this.month + this.getName();
    }

    @Override
    @NotNull
    public SolarWeek next(int n) {
        SolarMonth m;
        int d;
        int startIndex;
        block5: {
            block4: {
                startIndex = this.start.getIndex();
                d = this.index;
                m = this.month;
                if (n <= 0) break block4;
                d += n;
                int weekCount = m.getWeekCount(startIndex);
                while (d >= weekCount) {
                    d -= weekCount;
                    if (!Intrinsics.areEqual((Object)new SolarDay((m = m.next(1)).getYear(), m.getMonth(), 1).getWeek(), (Object)this.start)) {
                        ++d;
                    }
                    weekCount = m.getWeekCount(startIndex);
                }
                break block5;
            }
            if (n >= 0) break block5;
            d += n;
            while (d < 0) {
                if (!Intrinsics.areEqual((Object)new SolarDay(m.getYear(), m.getMonth(), 1).getWeek(), (Object)this.start)) {
                    --d;
                }
                m = m.next(-1);
                d += m.getWeekCount(startIndex);
            }
        }
        return new SolarWeek(m.getYear(), m.getMonth(), d, startIndex);
    }

    @NotNull
    public final SolarDay getFirstDay() {
        SolarDay firstDay = new SolarDay(this.getYear(), this.getMonth(), 1);
        return firstDay.next(this.index * 7 - this.indexOf(firstDay.getWeek().getIndex() - this.start.getIndex(), 7));
    }

    @NotNull
    public final List<SolarDay> getDays() {
        List l = new ArrayList(7);
        SolarDay d = this.getFirstDay();
        l.add(d);
        for (int i = 1; i < 7; ++i) {
            l.add(d.next(i));
        }
        return l;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SolarWeek && Intrinsics.areEqual((Object)((SolarWeek)other).getFirstDay(), (Object)this.getFirstDay());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final SolarWeek fromYm(int year, int month, int index, int start) {
        return Companion.fromYm(year, month, index, start);
    }

    static {
        String[] stringArray = new String[]{"\u7b2c\u4e00\u5468", "\u7b2c\u4e8c\u5468", "\u7b2c\u4e09\u5468", "\u7b2c\u56db\u5468", "\u7b2c\u4e94\u5468", "\u7b2c\u516d\u5468"};
        NAMES = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/tyme/solar/SolarWeek$Companion;", "", "<init>", "()V", "NAMES", "", "", "getNAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fromYm", "Lcom/tyme/solar/SolarWeek;", "year", "", "month", "index", "start", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getNAMES() {
            return NAMES;
        }

        @JvmStatic
        @NotNull
        public final SolarWeek fromYm(int year, int month, int index, int start) {
            return new SolarWeek(year, month, index, start);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

