/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.AbstractTyme;
import com.tyme.culture.phenology.Phenology;
import com.tyme.jd.JulianDay;
import com.tyme.lunar.LunarDay;
import com.tyme.lunar.LunarHour;
import com.tyme.sixtycycle.SixtyCycleHour;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTerm;
import com.tyme.util.IntUtilKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020&J\u0013\u0010'\u001a\u00020\u00192\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/tyme/solar/SolarTime;", "Lcom/tyme/AbstractTyme;", "year", "", "month", "day", "hour", "minute", "second", "<init>", "(IIIIII)V", "Lcom/tyme/solar/SolarDay;", "getSolarDay", "getYear", "getMonth", "getDay", "getHour", "getMinute", "getSecond", "getName", "", "toString", "next", "n", "isBefore", "", "target", "isAfter", "getTerm", "Lcom/tyme/solar/SolarTerm;", "getPhenology", "Lcom/tyme/culture/phenology/Phenology;", "getJulianDay", "Lcom/tyme/jd/JulianDay;", "subtract", "getLunarHour", "Lcom/tyme/lunar/LunarHour;", "getSixtyCycleHour", "Lcom/tyme/sixtycycle/SixtyCycleHour;", "equals", "other", "", "hashCode", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nSolarTime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolarTime.kt\ncom/tyme/solar/SolarTime\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,267:1\n1#2:268\n*E\n"})
public final class SolarTime
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int hour;
    private int minute;
    private int second;
    @NotNull
    private SolarDay day;

    public SolarTime(int year, int month, int day, int hour, int minute, int second) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        int n = this.hour;
        if (!(0 <= n ? n < 24 : false)) {
            boolean $i$a$-require-SolarTime$42 = false;
            String $i$a$-require-SolarTime$42 = "illegal hour: " + this.hour;
            throw new IllegalArgumentException($i$a$-require-SolarTime$42.toString());
        }
        n = this.minute;
        if (!(0 <= n ? n < 60 : false)) {
            boolean $i$a$-require-SolarTime$52 = false;
            String $i$a$-require-SolarTime$52 = "illegal minute: " + this.minute;
            throw new IllegalArgumentException($i$a$-require-SolarTime$52.toString());
        }
        n = this.second;
        if (!(0 <= n ? n < 60 : false)) {
            boolean bl = false;
            String string = "illegal second: " + this.second;
            throw new IllegalArgumentException(string.toString());
        }
        this.day = new SolarDay(year, month, day);
    }

    @NotNull
    public final SolarDay getSolarDay() {
        return this.day;
    }

    public final int getYear() {
        return this.day.getYear();
    }

    public final int getMonth() {
        return this.day.getMonth();
    }

    public final int getDay() {
        return this.day.getDay();
    }

    public final int getHour() {
        return this.hour;
    }

    public final int getMinute() {
        return this.minute;
    }

    public final int getSecond() {
        return this.second;
    }

    @Override
    @NotNull
    public String getName() {
        return IntUtilKt.pad2(this.hour) + ":" + IntUtilKt.pad2(this.minute) + ":" + IntUtilKt.pad2(this.second);
    }

    @Override
    @NotNull
    public String toString() {
        return this.day + " " + this.getName();
    }

    @Override
    @NotNull
    public SolarTime next(int n) {
        if (n == 0) {
            return new SolarTime(this.getYear(), this.getMonth(), this.getDay(), this.hour, this.minute, this.second);
        }
        int ts = this.second + n;
        int tm = this.minute + ts / 60;
        if ((ts %= 60) < 0) {
            ts += 60;
            --tm;
        }
        int th = this.hour + tm / 60;
        if ((tm %= 60) < 0) {
            tm += 60;
            --th;
        }
        int td = th / 24;
        if ((th %= 24) < 0) {
            th += 24;
            --td;
        }
        SolarDay d = this.day.next(td);
        return new SolarTime(d.getYear(), d.getMonth(), d.getDay(), th, tm, ts);
    }

    public final boolean isBefore(@NotNull SolarTime target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!Intrinsics.areEqual((Object)this.day, (Object)target.getSolarDay())) {
            return this.day.isBefore(target.getSolarDay());
        }
        if (this.hour != target.getHour()) {
            return this.hour < target.getHour();
        }
        return this.minute != target.getMinute() ? this.minute < target.getMinute() : this.second < target.getSecond();
    }

    public final boolean isAfter(@NotNull SolarTime target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!Intrinsics.areEqual((Object)this.day, (Object)target.getSolarDay())) {
            return this.day.isAfter(target.getSolarDay());
        }
        if (this.hour != target.getHour()) {
            return this.hour > target.getHour();
        }
        return this.minute != target.getMinute() ? this.minute > target.getMinute() : this.second > target.getSecond();
    }

    @NotNull
    public final SolarTerm getTerm() {
        SolarTerm term = this.day.getTerm();
        if (this.isBefore(term.getJulianDay().getSolarTime())) {
            term = term.next(-1);
        }
        return term;
    }

    @NotNull
    public final Phenology getPhenology() {
        Phenology p = this.day.getPhenology();
        if (this.isBefore(p.getJulianDay().getSolarTime())) {
            p = p.next(-1);
        }
        return p;
    }

    @NotNull
    public final JulianDay getJulianDay() {
        return JulianDay.Companion.fromYmdHms(this.day.getYear(), this.day.getMonth(), this.day.getDay(), this.hour, this.minute, this.second);
    }

    public final int subtract(@NotNull SolarTime target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int days = this.day.subtract(target.getSolarDay());
        int cs = this.hour * 3600 + this.minute * 60 + this.second;
        int ts = target.getHour() * 3600 + target.getMinute() * 60 + target.getSecond();
        int seconds = cs - ts;
        if (seconds < 0) {
            seconds += 86400;
            --days;
        }
        return seconds += days * 86400;
    }

    @NotNull
    public final LunarHour getLunarHour() {
        LunarDay d = this.day.getLunarDay();
        return new LunarHour(d.getYear(), d.getMonth(), d.getDay(), this.hour, this.minute, this.second);
    }

    @NotNull
    public final SixtyCycleHour getSixtyCycleHour() {
        return new SixtyCycleHour(this);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SolarTime && Intrinsics.areEqual((Object)this.toString(), (Object)((SolarTime)other).toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final SolarTime fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        return Companion.fromYmdHms(year, month, day, hour, minute, second);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0007\u00a8\u0006\r"}, d2={"Lcom/tyme/solar/SolarTime$Companion;", "", "<init>", "()V", "fromYmdHms", "Lcom/tyme/solar/SolarTime;", "year", "", "month", "day", "hour", "minute", "second", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SolarTime fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
            return new SolarTime(year, month, day, hour, minute, second);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

