/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.LoopTyme;
import com.tyme.jd.JulianDay;
import com.tyme.util.ShouXingUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0004J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u000bJ\u0013\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/tyme/solar/SolarTerm;", "Lcom/tyme/LoopTyme;", "year", "", "index", "<init>", "(II)V", "name", "", "(ILjava/lang/String;)V", "cursoryJulianDay", "", "initByYear", "", "offset", "next", "n", "isJie", "", "isQi", "getJulianDay", "Lcom/tyme/jd/JulianDay;", "getYear", "getCursoryJulianDay", "equals", "other", "", "hashCode", "Companion", "tyme4kt"})
public final class SolarTerm
extends LoopTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int year;
    private double cursoryJulianDay;
    @NotNull
    private static final String[] NAMES;

    public SolarTerm(int year, int index) {
        super(NAMES, index);
        int size = this.getSize();
        this.initByYear((year * size + index) / size, this.getIndex());
    }

    public SolarTerm(int year, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(NAMES, name);
        this.initByYear(year, this.getIndex());
    }

    protected final void initByYear(int year, int offset) {
        double jd = Math.floor((double)(year - 2000) * 365.2422 + (double)180);
        double w = Math.floor((jd - (double)355 + (double)183) / 365.2422) * 365.2422 + (double)355;
        if (ShouXingUtil.INSTANCE.calcQi(w) > jd) {
            w -= 365.2422;
        }
        this.year = year;
        this.cursoryJulianDay = ShouXingUtil.INSTANCE.calcQi(w + 15.2184 * (double)offset);
    }

    @Override
    @NotNull
    public SolarTerm next(int n) {
        int size = this.getSize();
        int i = this.getIndex() + n;
        return new SolarTerm((this.year * size + i) / size, this.indexOf(i));
    }

    public final boolean isJie() {
        return this.getIndex() % 2 == 1;
    }

    public final boolean isQi() {
        return this.getIndex() % 2 == 0;
    }

    @NotNull
    public final JulianDay getJulianDay() {
        return new JulianDay(ShouXingUtil.INSTANCE.qiAccurate2(this.cursoryJulianDay) + 2451545.0);
    }

    public final int getYear() {
        return this.year;
    }

    public final double getCursoryJulianDay() {
        return this.cursoryJulianDay;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SolarTerm && Intrinsics.areEqual((Object)this.toString(), (Object)((SolarTerm)other).toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final SolarTerm fromIndex(int year, int index) {
        return Companion.fromIndex(year, index);
    }

    @JvmStatic
    @NotNull
    public static final SolarTerm fromName(int year, @NotNull String name) {
        return Companion.fromName(year, name);
    }

    static {
        String[] stringArray = new String[]{"\u51ac\u81f3", "\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea"};
        NAMES = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0006H\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/tyme/solar/SolarTerm$Companion;", "", "<init>", "()V", "NAMES", "", "", "getNAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fromIndex", "Lcom/tyme/solar/SolarTerm;", "year", "", "index", "fromName", "name", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getNAMES() {
            return NAMES;
        }

        @JvmStatic
        @NotNull
        public final SolarTerm fromIndex(int year, int index) {
            return new SolarTerm(year, index);
        }

        @JvmStatic
        @NotNull
        public final SolarTerm fromName(int year, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new SolarTerm(year, name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

