/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.rabbyung;

import com.tyme.AbstractTyme;
import com.tyme.culture.Zodiac;
import com.tyme.rabbyung.RabByungElement;
import com.tyme.rabbyung.RabByungMonth;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.solar.SolarYear;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\u0003J\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0003J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/tyme/rabbyung/RabByungYear;", "Lcom/tyme/AbstractTyme;", "rabByungIndex", "", "sixtyCycle", "Lcom/tyme/sixtycycle/SixtyCycle;", "<init>", "(ILcom/tyme/sixtycycle/SixtyCycle;)V", "getRabByungIndex", "getSixtyCycle", "getZodiac", "Lcom/tyme/culture/Zodiac;", "getElement", "Lcom/tyme/rabbyung/RabByungElement;", "getName", "", "next", "n", "getYear", "getLeapMonth", "getSolarYear", "Lcom/tyme/solar/SolarYear;", "getFirstMonth", "Lcom/tyme/rabbyung/RabByungMonth;", "getMonthCount", "getMonths", "", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nRabByungYear.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RabByungYear.kt\ncom/tyme/rabbyung/RabByungYear\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class RabByungYear
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int rabByungIndex;
    @NotNull
    private SixtyCycle sixtyCycle;

    public RabByungYear(int rabByungIndex, @NotNull SixtyCycle sixtyCycle) {
        Intrinsics.checkNotNullParameter((Object)sixtyCycle, (String)"sixtyCycle");
        this.rabByungIndex = rabByungIndex;
        this.sixtyCycle = sixtyCycle;
        int n = this.rabByungIndex;
        if (!(0 <= n ? n < 151 : false)) {
            boolean bl = false;
            String string = "illegal rab-byung index: " + this.rabByungIndex;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getRabByungIndex() {
        return this.rabByungIndex;
    }

    @NotNull
    public final SixtyCycle getSixtyCycle() {
        return this.sixtyCycle;
    }

    @NotNull
    public final Zodiac getZodiac() {
        return this.sixtyCycle.getEarthBranch().getZodiac();
    }

    @NotNull
    public final RabByungElement getElement() {
        return new RabByungElement(this.sixtyCycle.getHeavenStem().getElement().getIndex());
    }

    @Override
    @NotNull
    public String getName() {
        String[] stringArray = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        String[] digits = stringArray;
        String[] stringArray2 = new String[]{"", "\u5341", "\u767e"};
        String[] units = stringArray2;
        int n = this.rabByungIndex + 1;
        StringBuilder s = new StringBuilder();
        int pos = 0;
        while (n > 0) {
            int digit = n % 10;
            if (digit > 0) {
                s.insert(0, digits[digit] + units[pos]);
            } else if (((CharSequence)s).length() > 0) {
                s.insert(0, digits[digit]);
            }
            n /= 10;
            ++pos;
        }
        String string = s.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String letter = string;
        if (StringsKt.startsWith$default((String)letter, (String)"\u4e00\u5341", (boolean)false, (int)2, null)) {
            String string2 = letter.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            letter = string2;
        }
        return "\u7b2c" + letter + "\u9976\u8fe5" + this.getElement() + this.getZodiac() + "\u5e74";
    }

    @Override
    @NotNull
    public RabByungYear next(int n) {
        return Companion.fromYear(this.getYear() + n);
    }

    public final int getYear() {
        return 1024 + this.rabByungIndex * 60 + this.sixtyCycle.getIndex();
    }

    public final int getLeapMonth() {
        int y = 1;
        int m = 4;
        int t = 0;
        int currentYear = this.getYear();
        while (y < currentYear) {
            int i = m - 1 + (t % 2 == 0 ? 33 : 32);
            y = (y * 12 + i) / 12;
            m = i % 12 + 1;
            ++t;
        }
        return y == currentYear ? m : 0;
    }

    @NotNull
    public final SolarYear getSolarYear() {
        return new SolarYear(this.getYear());
    }

    @NotNull
    public final RabByungMonth getFirstMonth() {
        return new RabByungMonth(this, 1);
    }

    public final int getMonthCount() {
        return this.getLeapMonth() < 1 ? 12 : 13;
    }

    @NotNull
    public final List<RabByungMonth> getMonths() {
        List l = new ArrayList();
        int leapMonth = this.getLeapMonth();
        for (int i = 1; i < 13; ++i) {
            l.add(new RabByungMonth(this, i));
            if (i != leapMonth) continue;
            l.add(new RabByungMonth(this, -i));
        }
        return l;
    }

    @JvmStatic
    @NotNull
    public static final RabByungYear fromSixtyCycle(int rabByungIndex, @NotNull SixtyCycle sixtyCycle) {
        return Companion.fromSixtyCycle(rabByungIndex, sixtyCycle);
    }

    @JvmStatic
    @NotNull
    public static final RabByungYear fromElementZodiac(int rabByungIndex, @NotNull RabByungElement element, @NotNull Zodiac zodiac) {
        return Companion.fromElementZodiac(rabByungIndex, element, zodiac);
    }

    @JvmStatic
    @NotNull
    public static final RabByungYear fromYear(int year) {
        return Companion.fromYear(year);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J \u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/tyme/rabbyung/RabByungYear$Companion;", "", "<init>", "()V", "fromSixtyCycle", "Lcom/tyme/rabbyung/RabByungYear;", "rabByungIndex", "", "sixtyCycle", "Lcom/tyme/sixtycycle/SixtyCycle;", "fromElementZodiac", "element", "Lcom/tyme/rabbyung/RabByungElement;", "zodiac", "Lcom/tyme/culture/Zodiac;", "fromYear", "year", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RabByungYear fromSixtyCycle(int rabByungIndex, @NotNull SixtyCycle sixtyCycle) {
            Intrinsics.checkNotNullParameter((Object)sixtyCycle, (String)"sixtyCycle");
            return new RabByungYear(rabByungIndex, sixtyCycle);
        }

        @JvmStatic
        @NotNull
        public final RabByungYear fromElementZodiac(int rabByungIndex, @NotNull RabByungElement element, @NotNull Zodiac zodiac) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)zodiac, (String)"zodiac");
            for (int i = 0; i < 60; ++i) {
                SixtyCycle sixtyCycle = new SixtyCycle(i);
                if (!sixtyCycle.getEarthBranch().getZodiac().equals(zodiac) || sixtyCycle.getHeavenStem().getElement().getIndex() != element.getIndex()) continue;
                return new RabByungYear(rabByungIndex, sixtyCycle);
            }
            throw new IllegalArgumentException("illegal rab-byung element " + element + ", zodiac " + zodiac);
        }

        @JvmStatic
        @NotNull
        public final RabByungYear fromYear(int year) {
            return new RabByungYear((year - 1024) / 60, new SixtyCycle(year - 4));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

