/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.lunar;

import com.tyme.AbstractTyme;
import com.tyme.culture.Week;
import com.tyme.lunar.LunarDay;
import com.tyme.lunar.LunarMonth;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/tyme/lunar/LunarWeek;", "Lcom/tyme/AbstractTyme;", "year", "", "month", "index", "start", "<init>", "(IIII)V", "Lcom/tyme/lunar/LunarMonth;", "Lcom/tyme/culture/Week;", "getLunarMonth", "getYear", "getMonth", "getIndex", "getStart", "getName", "", "toString", "next", "n", "getFirstDay", "Lcom/tyme/lunar/LunarDay;", "getDays", "", "equals", "", "other", "", "hashCode", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nLunarWeek.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LunarWeek.kt\ncom/tyme/lunar/LunarWeek\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class LunarWeek
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int index;
    @NotNull
    private LunarMonth month;
    @NotNull
    private Week start;
    @NotNull
    private static final String[] NAMES;

    public LunarWeek(int year, int month, int index, int start) {
        this.index = index;
        int n = this.index;
        if (!(0 <= n ? n < 6 : false)) {
            boolean $i$a$-require-LunarWeek$42 = false;
            String $i$a$-require-LunarWeek$42 = "illegal lunar week index: " + this.index;
            throw new IllegalArgumentException($i$a$-require-LunarWeek$42.toString());
        }
        if (!(0 <= start ? start < 7 : false)) {
            boolean bl = false;
            String string = "illegal lunar week start: " + start;
            throw new IllegalArgumentException(string.toString());
        }
        LunarMonth m = LunarMonth.Companion.fromYm(year, month);
        if (!(this.index < m.getWeekCount(start))) {
            boolean bl = false;
            String string = "illegal lunar week index: " + this.index + " in month: " + m;
            throw new IllegalArgumentException(string.toString());
        }
        this.month = m;
        this.start = new Week(start);
    }

    @NotNull
    public final LunarMonth getLunarMonth() {
        return this.month;
    }

    public final int getYear() {
        return this.month.getYear();
    }

    public final int getMonth() {
        return this.month.getMonthWithLeap();
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final Week getStart() {
        return this.start;
    }

    @Override
    @NotNull
    public String getName() {
        return NAMES[this.index];
    }

    @Override
    @NotNull
    public String toString() {
        return this.month + this.getName();
    }

    @Override
    @NotNull
    public LunarWeek next(int n) {
        int d;
        int startIndex = this.start.getIndex();
        if (n == 0) {
            return new LunarWeek(this.getYear(), this.getMonth(), this.index, startIndex);
        }
        LunarMonth m = this.month;
        if (n > 0) {
            int weekCount = m.getWeekCount(startIndex);
            while (d >= weekCount) {
                d -= weekCount;
                if (!Intrinsics.areEqual((Object)new LunarDay((m = m.next(1)).getYear(), m.getMonthWithLeap(), 1).getWeek(), (Object)this.start)) {
                    ++d;
                }
                weekCount = m.getWeekCount(startIndex);
            }
        } else {
            for (d = this.index + n; d < 0; d += m.getWeekCount(startIndex)) {
                if (!Intrinsics.areEqual((Object)new LunarDay(m.getYear(), m.getMonthWithLeap(), 1).getWeek(), (Object)this.start)) {
                    --d;
                }
                m = m.next(-1);
            }
        }
        return new LunarWeek(m.getYear(), m.getMonthWithLeap(), d, startIndex);
    }

    @NotNull
    public final LunarDay getFirstDay() {
        LunarDay firstDay = new LunarDay(this.getYear(), this.getMonth(), 1);
        return firstDay.next(this.index * 7 - this.indexOf(firstDay.getWeek().getIndex() - this.start.getIndex(), 7));
    }

    @NotNull
    public final List<LunarDay> getDays() {
        List l = new ArrayList(7);
        LunarDay d = this.getFirstDay();
        l.add(d);
        for (int i = 1; i < 7; ++i) {
            l.add(d.next(i));
        }
        return l;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof LunarWeek && Intrinsics.areEqual((Object)this.toString(), (Object)((LunarWeek)other).toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final LunarWeek fromYm(int year, int month, int index, int start) {
        return Companion.fromYm(year, month, index, start);
    }

    static {
        String[] stringArray = new String[]{"\u7b2c\u4e00\u5468", "\u7b2c\u4e8c\u5468", "\u7b2c\u4e09\u5468", "\u7b2c\u56db\u5468", "\u7b2c\u4e94\u5468", "\u7b2c\u516d\u5468"};
        NAMES = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/tyme/lunar/LunarWeek$Companion;", "", "<init>", "()V", "NAMES", "", "", "getNAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fromYm", "Lcom/tyme/lunar/LunarWeek;", "year", "", "month", "index", "start", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getNAMES() {
            return NAMES;
        }

        @JvmStatic
        @NotNull
        public final LunarWeek fromYm(int year, int month, int index, int start) {
            return new LunarWeek(year, month, index, start);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

