/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.lunar;

import com.tyme.AbstractTyme;
import com.tyme.culture.Taboo;
import com.tyme.culture.ren.MinorRen;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.culture.star.twelve.TwelveStar;
import com.tyme.eightchar.EightChar;
import com.tyme.eightchar.provider.EightCharProvider;
import com.tyme.eightchar.provider.impl.DefaultEightCharProvider;
import com.tyme.lunar.LunarDay;
import com.tyme.sixtycycle.EarthBranch;
import com.tyme.sixtycycle.HeavenStem;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleHour;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTerm;
import com.tyme.solar.SolarTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u00015B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0006\u0010\u001a\u001a\u00020\u0003J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0000J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\rJ\u0006\u0010(\u001a\u00020\u000fJ\u0006\u0010)\u001a\u00020*J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,J\u0006\u0010/\u001a\u000200J\u0013\u00101\u001a\u00020\u001e2\b\u00102\u001a\u0004\u0018\u000103H\u0096\u0002J\b\u00104\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/tyme/lunar/LunarHour;", "Lcom/tyme/AbstractTyme;", "year", "", "month", "day", "hour", "minute", "second", "<init>", "(IIIIII)V", "Lcom/tyme/lunar/LunarDay;", "solarTime", "Lcom/tyme/solar/SolarTime;", "sixtyCycleHour", "Lcom/tyme/sixtycycle/SixtyCycleHour;", "getLunarDay", "getYear", "getMonth", "getDay", "getHour", "getMinute", "getSecond", "getName", "", "toString", "getIndexInDay", "next", "n", "isBefore", "", "target", "isAfter", "getSixtyCycle", "Lcom/tyme/sixtycycle/SixtyCycle;", "getTwelveStar", "Lcom/tyme/culture/star/twelve/TwelveStar;", "getNineStar", "Lcom/tyme/culture/star/nine/NineStar;", "getSolarTime", "getSixtyCycleHour", "getEightChar", "Lcom/tyme/eightchar/EightChar;", "getRecommends", "", "Lcom/tyme/culture/Taboo;", "getAvoids", "getMinorRen", "Lcom/tyme/culture/ren/MinorRen;", "equals", "other", "", "hashCode", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nLunarHour.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LunarHour.kt\ncom/tyme/lunar/LunarHour\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,303:1\n1#2:304\n*E\n"})
public final class LunarHour
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int hour;
    private int minute;
    private int second;
    @NotNull
    private LunarDay day;
    @Nullable
    private SolarTime solarTime;
    @Nullable
    private SixtyCycleHour sixtyCycleHour;
    @NotNull
    private static EightCharProvider provider = new DefaultEightCharProvider();

    public LunarHour(int year, int month, int day, int hour, int minute, int second) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        int n = this.hour;
        if (!(0 <= n ? n < 24 : false)) {
            boolean $i$a$-require-LunarHour$42 = false;
            String $i$a$-require-LunarHour$42 = "illegal hour: " + this.hour;
            throw new IllegalArgumentException($i$a$-require-LunarHour$42.toString());
        }
        n = this.minute;
        if (!(0 <= n ? n < 60 : false)) {
            boolean $i$a$-require-LunarHour$52 = false;
            String $i$a$-require-LunarHour$52 = "illegal minute: " + this.minute;
            throw new IllegalArgumentException($i$a$-require-LunarHour$52.toString());
        }
        n = this.second;
        if (!(0 <= n ? n < 60 : false)) {
            boolean bl = false;
            String string = "illegal second: " + this.second;
            throw new IllegalArgumentException(string.toString());
        }
        this.day = new LunarDay(year, month, day);
    }

    @NotNull
    public final LunarDay getLunarDay() {
        return this.day;
    }

    public final int getYear() {
        return this.day.getYear();
    }

    public final int getMonth() {
        return this.day.getMonth();
    }

    public final int getDay() {
        return this.day.getDay();
    }

    public final int getHour() {
        return this.hour;
    }

    public final int getMinute() {
        return this.minute;
    }

    public final int getSecond() {
        return this.second;
    }

    @Override
    @NotNull
    public String getName() {
        return new EarthBranch(this.getIndexInDay()).getName() + "\u65f6";
    }

    @Override
    @NotNull
    public String toString() {
        return this.day + this.getSixtyCycle().getName() + "\u65f6";
    }

    public final int getIndexInDay() {
        return (this.hour + 1) / 2;
    }

    @Override
    @NotNull
    public LunarHour next(int n) {
        if (n == 0) {
            return new LunarHour(this.getYear(), this.getMonth(), this.getDay(), this.hour, this.minute, this.second);
        }
        int h = this.hour + n * 2;
        int diff = h < 0 ? -1 : 1;
        int hour = Math.abs(h);
        int days = hour / 24 * diff;
        if ((hour = hour % 24 * diff) < 0) {
            hour += 24;
            --days;
        }
        LunarDay d = this.day.next(days);
        return new LunarHour(d.getYear(), d.getMonth(), d.getDay(), hour, this.minute, this.second);
    }

    public final boolean isBefore(@NotNull LunarHour target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!Intrinsics.areEqual((Object)this.day, (Object)target.getLunarDay())) {
            return this.day.isBefore(target.getLunarDay());
        }
        if (this.hour != target.getHour()) {
            return this.hour < target.getHour();
        }
        return this.minute != target.getMinute() ? this.minute < target.getMinute() : this.second < target.getSecond();
    }

    public final boolean isAfter(@NotNull LunarHour target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!Intrinsics.areEqual((Object)this.day, (Object)target.getLunarDay())) {
            return this.day.isAfter(target.getLunarDay());
        }
        if (this.hour != target.getHour()) {
            return this.hour > target.getHour();
        }
        return this.minute != target.getMinute() ? this.minute > target.getMinute() : this.second > target.getSecond();
    }

    @NotNull
    public final SixtyCycle getSixtyCycle() {
        int earthBranchIndex = this.getIndexInDay() % 12;
        SixtyCycle d = this.day.getSixtyCycle();
        if (this.hour >= 23) {
            d = d.next(1);
        }
        return new SixtyCycle(new HeavenStem(d.getHeavenStem().getIndex() % 5 * 2 + earthBranchIndex).getName() + new EarthBranch(earthBranchIndex).getName());
    }

    @NotNull
    public final TwelveStar getTwelveStar() {
        return new TwelveStar(this.getSixtyCycle().getEarthBranch().getIndex() + (8 - this.getSixtyCycleHour().getDay().getEarthBranch().getIndex() % 6) * 2);
    }

    @NotNull
    public final NineStar getNineStar() {
        SolarDay solar = this.day.getSolarDay();
        SolarTerm dongZhi = new SolarTerm(solar.getYear(), 0);
        int earthBranchIndex = this.getIndexInDay() % 12;
        int[] nArray = new int[]{8, 5, 2};
        int index = nArray[this.day.getSixtyCycle().getEarthBranch().getIndex() % 3];
        index = !solar.isBefore(dongZhi.getJulianDay().getSolarDay()) && solar.isBefore(dongZhi.next(12).getJulianDay().getSolarDay()) ? 8 + earthBranchIndex - index : (index -= earthBranchIndex);
        return new NineStar(index);
    }

    @NotNull
    public final SolarTime getSolarTime() {
        if (this.solarTime == null) {
            SolarDay d = this.day.getSolarDay();
            this.solarTime = new SolarTime(d.getYear(), d.getMonth(), d.getDay(), this.hour, this.minute, this.second);
        }
        SolarTime solarTime = this.solarTime;
        Intrinsics.checkNotNull((Object)solarTime);
        return solarTime;
    }

    @NotNull
    public final SixtyCycleHour getSixtyCycleHour() {
        if (this.sixtyCycleHour == null) {
            this.sixtyCycleHour = this.getSolarTime().getSixtyCycleHour();
        }
        SixtyCycleHour sixtyCycleHour = this.sixtyCycleHour;
        Intrinsics.checkNotNull((Object)sixtyCycleHour);
        return sixtyCycleHour;
    }

    @NotNull
    public final EightChar getEightChar() {
        return provider.getEightChar(this);
    }

    @NotNull
    public final List<Taboo> getRecommends() {
        return Taboo.Companion.getHourRecommends(this.getSixtyCycleHour().getDay(), this.getSixtyCycle());
    }

    @NotNull
    public final List<Taboo> getAvoids() {
        return Taboo.Companion.getHourAvoids(this.getSixtyCycleHour().getDay(), this.getSixtyCycle());
    }

    @NotNull
    public final MinorRen getMinorRen() {
        return this.day.getMinorRen().next(this.getIndexInDay());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof LunarHour && Intrinsics.areEqual((Object)this.toString(), (Object)((LunarHour)other).toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final LunarHour fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        return Companion.fromYmdHms(year, month, day, hour, minute, second);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/tyme/lunar/LunarHour$Companion;", "", "<init>", "()V", "provider", "Lcom/tyme/eightchar/provider/EightCharProvider;", "getProvider", "()Lcom/tyme/eightchar/provider/EightCharProvider;", "setProvider", "(Lcom/tyme/eightchar/provider/EightCharProvider;)V", "fromYmdHms", "Lcom/tyme/lunar/LunarHour;", "year", "", "month", "day", "hour", "minute", "second", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EightCharProvider getProvider() {
            return provider;
        }

        public final void setProvider(@NotNull EightCharProvider eightCharProvider) {
            Intrinsics.checkNotNullParameter((Object)eightCharProvider, (String)"<set-?>");
            provider = eightCharProvider;
        }

        @JvmStatic
        @NotNull
        public final LunarHour fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
            return new LunarHour(year, month, day, hour, minute, second);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

