/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.festival;

import com.tyme.AbstractTyme;
import com.tyme.enums.FestivalType;
import com.tyme.solar.SolarDay;
import com.tyme.util.IntUtilKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\tH\u0016J\u0006\u0010\u000f\u001a\u00020\u0007J\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0007J\b\u0010\u0013\u001a\u00020\tH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0015\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/tyme/festival/SolarFestival;", "Lcom/tyme/AbstractTyme;", "type", "Lcom/tyme/enums/FestivalType;", "day", "Lcom/tyme/solar/SolarDay;", "startYear", "", "data", "", "<init>", "(Lcom/tyme/enums/FestivalType;Lcom/tyme/solar/SolarDay;ILjava/lang/String;)V", "index", "name", "getName", "getIndex", "getDay", "getType", "getStartYear", "toString", "next", "n", "Companion", "tyme4kt"})
public final class SolarFestival
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private FestivalType type;
    @NotNull
    private SolarDay day;
    private int startYear;
    private int index;
    @NotNull
    private String name;
    @NotNull
    private static final String[] NAMES;
    @NotNull
    private static String DATA;

    public SolarFestival(@NotNull FestivalType type, @NotNull SolarDay day, int startYear, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.type = type;
        this.day = day;
        this.startYear = startYear;
        String string = data.substring(1, 3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        this.index = Integer.parseInt(string, CharsKt.checkRadix((int)10));
        this.name = NAMES[this.index];
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final SolarDay getDay() {
        return this.day;
    }

    @NotNull
    public final FestivalType getType() {
        return this.type;
    }

    public final int getStartYear() {
        return this.startYear;
    }

    @Override
    @NotNull
    public String toString() {
        return this.day + " " + this.name;
    }

    @Override
    @Nullable
    public SolarFestival next(int n) {
        int size = NAMES.length;
        int i = this.index + n;
        return Companion.fromIndex((this.day.getYear() * size + i) / size, this.indexOf(i, size));
    }

    @JvmStatic
    @Nullable
    public static final SolarFestival fromIndex(int year, int index) {
        return Companion.fromIndex(year, index);
    }

    @JvmStatic
    @Nullable
    public static final SolarFestival fromYmd(int year, int month, int day) {
        return Companion.fromYmd(year, month, day);
    }

    static {
        String[] stringArray = new String[]{"\u5143\u65e6", "\u4e09\u516b\u5987\u5973\u8282", "\u690d\u6811\u8282", "\u4e94\u4e00\u52b3\u52a8\u8282", "\u4e94\u56db\u9752\u5e74\u8282", "\u516d\u4e00\u513f\u7ae5\u8282", "\u5efa\u515a\u8282", "\u516b\u4e00\u5efa\u519b\u8282", "\u6559\u5e08\u8282", "\u56fd\u5e86\u8282"};
        NAMES = stringArray;
        DATA = "@00001011950@01003081950@02003121979@03005011950@04005041950@05006011950@06007011941@07008011933@08009101985@09010011950";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/tyme/festival/SolarFestival$Companion;", "", "<init>", "()V", "NAMES", "", "", "getNAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "DATA", "getDATA", "()Ljava/lang/String;", "setDATA", "(Ljava/lang/String;)V", "fromIndex", "Lcom/tyme/festival/SolarFestival;", "year", "", "index", "fromYmd", "month", "day", "tyme4kt"})
    @SourceDebugExtension(value={"SMAP\nSolarFestival.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolarFestival.kt\ncom/tyme/festival/SolarFestival$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getNAMES() {
            return NAMES;
        }

        @NotNull
        public final String getDATA() {
            return DATA;
        }

        public final void setDATA(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            DATA = string;
        }

        @JvmStatic
        @Nullable
        public final SolarFestival fromIndex(int year, int index) {
            String data;
            int type;
            if (!(0 <= index ? index < this.getNAMES().length : false)) {
                boolean $i$a$-require-SolarFestival$Companion$fromIndex$22 = false;
                String $i$a$-require-SolarFestival$Companion$fromIndex$22 = "illegal index: " + index;
                throw new IllegalArgumentException($i$a$-require-SolarFestival$Companion$fromIndex$22.toString());
            }
            MatchResult matchResult = Regex.find$default((Regex)new Regex("@" + IntUtilKt.pad2(index) + "\\d+"), (CharSequence)this.getDATA(), (int)0, (int)2, null);
            if (matchResult != null && (type = (data = matchResult.getValue()).charAt(3) - 48) == 0) {
                String string = data.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int startYear = Integer.parseInt(string, CharsKt.checkRadix((int)10));
                if (year >= startYear) {
                    String string2 = data.substring(4, 6);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    int n = Integer.parseInt(string2, CharsKt.checkRadix((int)10));
                    String string3 = data.substring(6, 8);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    return new SolarFestival(FestivalType.DAY, new SolarDay(year, n, Integer.parseInt(string3, CharsKt.checkRadix((int)10))), startYear, data);
                }
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final SolarFestival fromYmd(int year, int month, int day) {
            StringsKt.padStart((String)String.valueOf(month), (int)2, (char)'0');
            MatchResult matchResult = Regex.find$default((Regex)new Regex("@\\d{2}0" + IntUtilKt.pad2(month) + IntUtilKt.pad2(day) + "\\d+"), (CharSequence)this.getDATA(), (int)0, (int)2, null);
            if (matchResult != null) {
                String data = matchResult.getValue();
                String string = data.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int startYear = Integer.parseInt(string, CharsKt.checkRadix((int)10));
                if (year >= startYear) {
                    return new SolarFestival(FestivalType.DAY, new SolarDay(year, month, day), startYear, data);
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

