/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.festival;

import com.tyme.AbstractTyme;
import com.tyme.enums.FestivalType;
import com.tyme.lunar.LunarDay;
import com.tyme.solar.SolarTerm;
import com.tyme.util.IntUtilKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000f\u001a\u00020\tH\u0016J\u0006\u0010\u0010\u001a\u00020\rJ\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0003J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007J\b\u0010\u0014\u001a\u00020\tH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/tyme/festival/LunarFestival;", "Lcom/tyme/AbstractTyme;", "type", "Lcom/tyme/enums/FestivalType;", "day", "Lcom/tyme/lunar/LunarDay;", "solarTerm", "Lcom/tyme/solar/SolarTerm;", "data", "", "<init>", "(Lcom/tyme/enums/FestivalType;Lcom/tyme/lunar/LunarDay;Lcom/tyme/solar/SolarTerm;Ljava/lang/String;)V", "index", "", "name", "getName", "getIndex", "getDay", "getType", "getSolarTerm", "toString", "next", "n", "equals", "", "other", "", "hashCode", "Companion", "tyme4kt"})
public final class LunarFestival
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private FestivalType type;
    @NotNull
    private LunarDay day;
    @Nullable
    private SolarTerm solarTerm;
    private int index;
    @NotNull
    private String name;
    @NotNull
    private static final String[] NAMES;
    @NotNull
    private static String DATA;

    public LunarFestival(@NotNull FestivalType type, @NotNull LunarDay day, @Nullable SolarTerm solarTerm, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.type = type;
        this.day = day;
        this.solarTerm = solarTerm;
        String string = data.substring(1, 3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        this.index = Integer.parseInt(string, CharsKt.checkRadix((int)10));
        this.name = NAMES[this.index];
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final LunarDay getDay() {
        return this.day;
    }

    @NotNull
    public final FestivalType getType() {
        return this.type;
    }

    @Nullable
    public final SolarTerm getSolarTerm() {
        return this.solarTerm;
    }

    @Override
    @NotNull
    public String toString() {
        return this.day + " " + this.name;
    }

    @Override
    @Nullable
    public LunarFestival next(int n) {
        int size = NAMES.length;
        int i = this.index + n;
        return Companion.fromIndex((this.day.getYear() * size + i) / size, this.indexOf(i, size));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof LunarFestival && Intrinsics.areEqual((Object)this.toString(), (Object)((LunarFestival)other).toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @Nullable
    public static final LunarFestival fromIndex(int year, int index) {
        return Companion.fromIndex(year, index);
    }

    @JvmStatic
    @Nullable
    public static final LunarFestival fromYmd(int year, int month, int day) {
        return Companion.fromYmd(year, month, day);
    }

    static {
        String[] stringArray = new String[]{"\u6625\u8282", "\u5143\u5bb5\u8282", "\u9f99\u5934\u8282", "\u4e0a\u5df3\u8282", "\u6e05\u660e\u8282", "\u7aef\u5348\u8282", "\u4e03\u5915\u8282", "\u4e2d\u5143\u8282", "\u4e2d\u79cb\u8282", "\u91cd\u9633\u8282", "\u51ac\u81f3\u8282", "\u814a\u516b\u8282", "\u9664\u5915"};
        NAMES = stringArray;
        DATA = "@0000101@0100115@0200202@0300303@04107@0500505@0600707@0700715@0800815@0900909@10124@1101208@122";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/tyme/festival/LunarFestival$Companion;", "", "<init>", "()V", "NAMES", "", "", "getNAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "DATA", "getDATA", "()Ljava/lang/String;", "setDATA", "(Ljava/lang/String;)V", "fromIndex", "Lcom/tyme/festival/LunarFestival;", "year", "", "index", "fromYmd", "month", "day", "tyme4kt"})
    @SourceDebugExtension(value={"SMAP\nLunarFestival.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LunarFestival.kt\ncom/tyme/festival/LunarFestival$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getNAMES() {
            return NAMES;
        }

        @NotNull
        public final String getDATA() {
            return DATA;
        }

        public final void setDATA(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            DATA = string;
        }

        @JvmStatic
        @Nullable
        public final LunarFestival fromIndex(int year, int index) {
            if (!(index >= 0 && index < this.getNAMES().length)) {
                boolean $i$a$-require-LunarFestival$Companion$fromIndex$22 = false;
                String $i$a$-require-LunarFestival$Companion$fromIndex$22 = "illegal index: " + index;
                throw new IllegalArgumentException($i$a$-require-LunarFestival$Companion$fromIndex$22.toString());
            }
            Regex regex = new Regex("@" + IntUtilKt.pad2(index) + "\\d+");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)this.getDATA(), (int)0, (int)2, null);
            if (matchResult != null) {
                String data = matchResult.getValue();
                int type = data.charAt(3) - 48;
                switch (type) {
                    case 0: {
                        String string = data.substring(4, 6);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        int n = Integer.parseInt(string, CharsKt.checkRadix((int)10));
                        String string2 = data.substring(6);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        return new LunarFestival(FestivalType.DAY, new LunarDay(year, n, Integer.parseInt(string2, CharsKt.checkRadix((int)10))), null, data);
                    }
                    case 1: {
                        String string = data.substring(4);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        SolarTerm solarTerm = new SolarTerm(year, Integer.parseInt(string, CharsKt.checkRadix((int)10)));
                        return new LunarFestival(FestivalType.TERM, solarTerm.getJulianDay().getSolarDay().getLunarDay(), solarTerm, data);
                    }
                    case 2: {
                        return new LunarFestival(FestivalType.EVE, new LunarDay(year + 1, 1, 1).next(-1), null, data);
                    }
                }
                return null;
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final LunarFestival fromYmd(int year, int month, int day) {
            LunarDay lunarDay;
            LunarDay nextDay;
            MatchResult matchResult = Regex.find$default((Regex)new Regex("@\\d{2}0" + IntUtilKt.pad2(month) + IntUtilKt.pad2(day)), (CharSequence)this.getDATA(), (int)0, (int)2, null);
            if (matchResult != null) {
                return new LunarFestival(FestivalType.DAY, new LunarDay(year, month, day), null, matchResult.getValue());
            }
            Regex regex = new Regex("@\\d{2}1\\d{2}");
            Sequence matches = Regex.findAll$default((Regex)regex, (CharSequence)this.getDATA(), (int)0, (int)2, null);
            for (MatchResult match : matches) {
                String data = match.getValue();
                String string = data.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                SolarTerm solarTerm = new SolarTerm(year, Integer.parseInt(string, CharsKt.checkRadix((int)10)));
                LunarDay lunarDay2 = solarTerm.getJulianDay().getSolarDay().getLunarDay();
                if (lunarDay2.getYear() != year || lunarDay2.getMonth() != month || lunarDay2.getDay() != day) continue;
                return new LunarFestival(FestivalType.TERM, lunarDay2, solarTerm, data);
            }
            matchResult = Regex.find$default((Regex)new Regex("@\\d{2}2"), (CharSequence)this.getDATA(), (int)0, (int)2, null);
            if (matchResult != null && (nextDay = (lunarDay = new LunarDay(year, month, day)).next(1)).getMonth() == 1 && nextDay.getDay() == 1) {
                return new LunarFestival(FestivalType.EVE, lunarDay, null, matchResult.getValue());
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

