/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.eightchar;

import com.tyme.AbstractCulture;
import com.tyme.sixtycycle.EarthBranch;
import com.tyme.sixtycycle.HeavenStem;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTerm;
import com.tyme.solar.SolarTime;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\t\u0012\u0006\u0010\u0006\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\tJ\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\tJ\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\tJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/tyme/eightchar/EightChar;", "Lcom/tyme/AbstractCulture;", "year", "", "month", "day", "hour", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lcom/tyme/sixtycycle/SixtyCycle;", "(Lcom/tyme/sixtycycle/SixtyCycle;Lcom/tyme/sixtycycle/SixtyCycle;Lcom/tyme/sixtycycle/SixtyCycle;Lcom/tyme/sixtycycle/SixtyCycle;)V", "getYear", "getMonth", "getDay", "getHour", "getFetalOrigin", "getFetalBreath", "getOwnSign", "getBodySign", "getSolarTimes", "", "Lcom/tyme/solar/SolarTime;", "startYear", "", "endYear", "getName", "equals", "", "other", "", "hashCode", "tyme4kt"})
public final class EightChar
extends AbstractCulture {
    @NotNull
    private SixtyCycle year;
    @NotNull
    private SixtyCycle month;
    @NotNull
    private SixtyCycle day;
    @NotNull
    private SixtyCycle hour;

    public EightChar(@NotNull String year, @NotNull String month, @NotNull String day, @NotNull String hour) {
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        Intrinsics.checkNotNullParameter((Object)hour, (String)"hour");
        this.year = new SixtyCycle(year);
        this.month = new SixtyCycle(month);
        this.day = new SixtyCycle(day);
        this.hour = new SixtyCycle(hour);
    }

    public EightChar(@NotNull SixtyCycle year, @NotNull SixtyCycle month, @NotNull SixtyCycle day, @NotNull SixtyCycle hour) {
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        Intrinsics.checkNotNullParameter((Object)hour, (String)"hour");
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
    }

    @NotNull
    public final SixtyCycle getYear() {
        return this.year;
    }

    @NotNull
    public final SixtyCycle getMonth() {
        return this.month;
    }

    @NotNull
    public final SixtyCycle getDay() {
        return this.day;
    }

    @NotNull
    public final SixtyCycle getHour() {
        return this.hour;
    }

    @NotNull
    public final SixtyCycle getFetalOrigin() {
        return new SixtyCycle(this.month.getHeavenStem().next(1).getName() + this.month.getEarthBranch().next(3).getName());
    }

    @NotNull
    public final SixtyCycle getFetalBreath() {
        return new SixtyCycle(this.day.getHeavenStem().next(5).getName() + new EarthBranch(13 - this.day.getEarthBranch().getIndex()).getName());
    }

    @NotNull
    public final SixtyCycle getOwnSign() {
        int offset;
        int h;
        int m = this.month.getEarthBranch().getIndex() - 1;
        if (m < 1) {
            m += 12;
        }
        if ((h = this.hour.getEarthBranch().getIndex() - 1) < 1) {
            h += 12;
        }
        offset = ((offset = m + h) >= 14 ? 26 : 14) - offset;
        return new SixtyCycle(new HeavenStem((this.year.getHeavenStem().getIndex() + 1) * 2 + offset - 1).getName() + new EarthBranch(offset + 1).getName());
    }

    @NotNull
    public final SixtyCycle getBodySign() {
        int offset = this.month.getEarthBranch().getIndex() - 1;
        if (offset < 1) {
            offset += 12;
        }
        if ((offset += this.hour.getEarthBranch().getIndex() + 1) > 12) {
            offset -= 12;
        }
        return new SixtyCycle(new HeavenStem((this.year.getHeavenStem().getIndex() + 1) * 2 + offset - 1).getName() + new EarthBranch(offset + 1).getName());
    }

    @NotNull
    public final List<SolarTime> getSolarTimes(int startYear, int endYear) {
        int[] nArray;
        List l = new ArrayList();
        int m = this.month.getEarthBranch().next(-2).getIndex();
        if (!Intrinsics.areEqual((Object)new HeavenStem((this.year.getHeavenStem().getIndex() + 1) * 2 + m), (Object)this.month.getHeavenStem())) {
            return l;
        }
        int y = this.year.next(-57).getIndex() + 1;
        m *= 2;
        int h = this.hour.getEarthBranch().getIndex() * 2;
        if (h == 0) {
            var8_7 = new int[]{0, 23};
            nArray = var8_7;
        } else {
            var8_7 = new int[]{h};
            nArray = var8_7;
        }
        int[] hours = nArray;
        int baseYear = startYear - 1;
        if (baseYear > y) {
            y += 60 * (int)Math.ceil((double)(baseYear - y) / 60.0);
        }
        while (y <= endYear) {
            SolarTime solarTime;
            SolarTerm term = new SolarTerm(y, 3);
            if (m > 0) {
                term = term.next(m);
            }
            if ((solarTime = term.getJulianDay().getSolarTime()).getYear() >= startYear) {
                SolarDay solarDay = solarTime.getSolarDay();
                int d = this.day.next(-solarDay.getLunarDay().getSixtyCycle().getIndex()).getIndex();
                if (d > 0) {
                    solarDay = solarDay.next(d);
                }
                for (int hour : hours) {
                    int mi = 0;
                    int s = 0;
                    if (d == 0 && hour == solarTime.getHour()) {
                        mi = solarTime.getMinute();
                        s = solarTime.getSecond();
                    }
                    SolarTime time = new SolarTime(solarDay.getYear(), solarDay.getMonth(), solarDay.getDay(), hour, mi, s);
                    if (d == 30) {
                        time = time.next(-3600);
                    }
                    if (!Intrinsics.areEqual((Object)time.getLunarHour().getEightChar(), (Object)this)) continue;
                    l.add(time);
                }
            }
            y += 60;
        }
        return l;
    }

    @Override
    @NotNull
    public String getName() {
        return this.year + " " + this.month + " " + this.day + " " + this.hour;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof EightChar && Intrinsics.areEqual((Object)this.toString(), (Object)((EightChar)other).toString());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }
}

