/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.eightchar;

import com.tyme.eightchar.ChildLimitInfo;
import com.tyme.eightchar.DecadeFortune;
import com.tyme.eightchar.EightChar;
import com.tyme.eightchar.Fortune;
import com.tyme.eightchar.provider.ChildLimitProvider;
import com.tyme.eightchar.provider.impl.DefaultChildLimitProvider;
import com.tyme.enums.Gender;
import com.tyme.enums.YinYang;
import com.tyme.sixtycycle.SixtyCycleYear;
import com.tyme.solar.SolarTerm;
import com.tyme.solar.SolarTime;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u0011J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u000bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\u0011J\u0006\u0010\"\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/tyme/eightchar/ChildLimit;", "", "birthTime", "Lcom/tyme/solar/SolarTime;", "gender", "Lcom/tyme/enums/Gender;", "<init>", "(Lcom/tyme/solar/SolarTime;Lcom/tyme/enums/Gender;)V", "eightChar", "Lcom/tyme/eightchar/EightChar;", "forward", "", "info", "Lcom/tyme/eightchar/ChildLimitInfo;", "getEightChar", "getGender", "getYearCount", "", "getMonthCount", "getDayCount", "getHourCount", "getMinuteCount", "getStartTime", "getEndTime", "isForward", "getStartDecadeFortune", "Lcom/tyme/eightchar/DecadeFortune;", "getDecadeFortune", "getStartFortune", "Lcom/tyme/eightchar/Fortune;", "getStartSixtyCycleYear", "Lcom/tyme/sixtycycle/SixtyCycleYear;", "getEndSixtyCycleYear", "getStartAge", "getEndAge", "Companion", "tyme4kt"})
public final class ChildLimit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Gender gender;
    @NotNull
    private EightChar eightChar;
    private boolean forward;
    @NotNull
    private ChildLimitInfo info;
    @NotNull
    private static ChildLimitProvider provider = new DefaultChildLimitProvider();

    public ChildLimit(@NotNull SolarTime birthTime, @NotNull Gender gender) {
        Intrinsics.checkNotNullParameter((Object)birthTime, (String)"birthTime");
        Intrinsics.checkNotNullParameter((Object)((Object)gender), (String)"gender");
        this.gender = gender;
        this.eightChar = birthTime.getLunarHour().getEightChar();
        boolean yang = YinYang.YANG == this.eightChar.getYear().getHeavenStem().getYinYang();
        boolean man = Gender.MAN == this.gender;
        this.forward = yang && man || !yang && !man;
        SolarTerm term = birthTime.getTerm();
        if (!term.isJie()) {
            term = term.next(-1);
        }
        if (this.forward) {
            term = term.next(2);
        }
        this.info = provider.getInfo(birthTime, term);
    }

    @NotNull
    public final EightChar getEightChar() {
        return this.eightChar;
    }

    @NotNull
    public final Gender getGender() {
        return this.gender;
    }

    public final int getYearCount() {
        return this.info.getYearCount();
    }

    public final int getMonthCount() {
        return this.info.getMonthCount();
    }

    public final int getDayCount() {
        return this.info.getDayCount();
    }

    public final int getHourCount() {
        return this.info.getHourCount();
    }

    public final int getMinuteCount() {
        return this.info.getMinuteCount();
    }

    @NotNull
    public final SolarTime getStartTime() {
        return this.info.getStartTime();
    }

    @NotNull
    public final SolarTime getEndTime() {
        return this.info.getEndTime();
    }

    public final boolean isForward() {
        return this.forward;
    }

    @NotNull
    public final DecadeFortune getStartDecadeFortune() {
        return new DecadeFortune(this, 0);
    }

    @NotNull
    public final DecadeFortune getDecadeFortune() {
        return new DecadeFortune(this, -1);
    }

    @NotNull
    public final Fortune getStartFortune() {
        return new Fortune(this, 0);
    }

    @NotNull
    public final SixtyCycleYear getStartSixtyCycleYear() {
        return new SixtyCycleYear(this.getStartTime().getYear());
    }

    @NotNull
    public final SixtyCycleYear getEndSixtyCycleYear() {
        return new SixtyCycleYear(this.getEndTime().getYear());
    }

    public final int getStartAge() {
        return 1;
    }

    public final int getEndAge() {
        int n = this.getEndSixtyCycleYear().getYear() - this.getStartSixtyCycleYear().getYear();
        return RangesKt.coerceAtLeast((int)n, (int)1);
    }

    @JvmStatic
    @NotNull
    public static final ChildLimit fromSolarTime(@NotNull SolarTime birthTime, @NotNull Gender gender) {
        return Companion.fromSolarTime(birthTime, gender);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/tyme/eightchar/ChildLimit$Companion;", "", "<init>", "()V", "provider", "Lcom/tyme/eightchar/provider/ChildLimitProvider;", "getProvider", "()Lcom/tyme/eightchar/provider/ChildLimitProvider;", "setProvider", "(Lcom/tyme/eightchar/provider/ChildLimitProvider;)V", "fromSolarTime", "Lcom/tyme/eightchar/ChildLimit;", "birthTime", "Lcom/tyme/solar/SolarTime;", "gender", "Lcom/tyme/enums/Gender;", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChildLimitProvider getProvider() {
            return provider;
        }

        public final void setProvider(@NotNull ChildLimitProvider childLimitProvider) {
            Intrinsics.checkNotNullParameter((Object)childLimitProvider, (String)"<set-?>");
            provider = childLimitProvider;
        }

        @JvmStatic
        @NotNull
        public final ChildLimit fromSolarTime(@NotNull SolarTime birthTime, @NotNull Gender gender) {
            Intrinsics.checkNotNullParameter((Object)birthTime, (String)"birthTime");
            Intrinsics.checkNotNullParameter((Object)((Object)gender), (String)"gender");
            return new ChildLimit(birthTime, gender);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

