/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.culture.fetus;

import com.tyme.AbstractCulture;
import com.tyme.culture.Direction;
import com.tyme.culture.fetus.FetusEarthBranch;
import com.tyme.culture.fetus.FetusHeavenStem;
import com.tyme.enums.Side;
import com.tyme.lunar.LunarDay;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleDay;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\tR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/tyme/culture/fetus/FetusDay;", "Lcom/tyme/AbstractCulture;", "sixtyCycle", "Lcom/tyme/sixtycycle/SixtyCycle;", "<init>", "(Lcom/tyme/sixtycycle/SixtyCycle;)V", "fetusHeavenStem", "Lcom/tyme/culture/fetus/FetusHeavenStem;", "fetusEarthBranch", "Lcom/tyme/culture/fetus/FetusEarthBranch;", "side", "Lcom/tyme/enums/Side;", "direction", "Lcom/tyme/culture/Direction;", "getName", "", "getSide", "getDirection", "getFetusHeavenStem", "getFetusEarthBranch", "Companion", "tyme4kt"})
public final class FetusDay
extends AbstractCulture {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private FetusHeavenStem fetusHeavenStem;
    @NotNull
    private FetusEarthBranch fetusEarthBranch;
    @NotNull
    private Side side;
    @NotNull
    private Direction direction;

    public FetusDay(@NotNull SixtyCycle sixtyCycle) {
        Intrinsics.checkNotNullParameter((Object)sixtyCycle, (String)"sixtyCycle");
        this.fetusHeavenStem = new FetusHeavenStem(sixtyCycle.getHeavenStem().getIndex() % 5);
        this.fetusEarthBranch = new FetusEarthBranch(sixtyCycle.getEarthBranch().getIndex() % 6);
        int[] nArray = new int[]{3, 3, 8, 8, 8, 8, 8, 1, 1, 1, 1, 1, 1, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, -9, -9, -9, -9, -9, -5, -5, -1, -1, -1, -3, -7, -7, -7, -7, -5, 7, 7, 7, 7, 7, 7, 2, 2, 2, 2, 2, 3, 3, 3, 3};
        int index = nArray[sixtyCycle.getIndex()];
        this.side = index < 0 ? Side.IN : Side.OUT;
        this.direction = new Direction(index);
    }

    @Override
    @NotNull
    public String getName() {
        Object s = this.fetusHeavenStem.getName() + this.fetusEarthBranch.getName();
        if (Intrinsics.areEqual((Object)"\u95e8\u95e8", (Object)s)) {
            s = "\u5360\u5927\u95e8";
        } else if (Intrinsics.areEqual((Object)"\u7893\u78e8\u7893", (Object)s)) {
            s = "\u5360\u7893\u78e8";
        } else if (Intrinsics.areEqual((Object)"\u623f\u5e8a\u5e8a", (Object)s)) {
            s = "\u5360\u623f\u5e8a";
        } else if (StringsKt.startsWith$default((String)s, (String)"\u95e8", (boolean)false, (int)2, null)) {
            s = "\u5360" + (String)s;
        }
        s = (String)s + " ";
        s = (String)s + (Side.IN == this.side ? "\u623f\u5185" : "\u5916");
        String directionName = this.direction.getName();
        if (Side.OUT == this.side && StringsKt.contains$default((CharSequence)"\u5317\u5357\u897f\u4e1c", (CharSequence)directionName, (boolean)false, (int)2, null)) {
            s = (String)s + "\u6b63";
        }
        s = (String)s + directionName;
        return s;
    }

    @NotNull
    public final Side getSide() {
        return this.side;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    @NotNull
    public final FetusHeavenStem getFetusHeavenStem() {
        return this.fetusHeavenStem;
    }

    @NotNull
    public final FetusEarthBranch getFetusEarthBranch() {
        return this.fetusEarthBranch;
    }

    @JvmStatic
    @NotNull
    public static final FetusDay fromLunarDay(@NotNull LunarDay lunarDay) {
        return Companion.fromLunarDay(lunarDay);
    }

    @JvmStatic
    @NotNull
    public static final FetusDay fromSixtyCycleDay(@NotNull SixtyCycleDay sixtyCycleDay) {
        return Companion.fromSixtyCycleDay(sixtyCycleDay);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/tyme/culture/fetus/FetusDay$Companion;", "", "<init>", "()V", "fromLunarDay", "Lcom/tyme/culture/fetus/FetusDay;", "lunarDay", "Lcom/tyme/lunar/LunarDay;", "fromSixtyCycleDay", "sixtyCycleDay", "Lcom/tyme/sixtycycle/SixtyCycleDay;", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FetusDay fromLunarDay(@NotNull LunarDay lunarDay) {
            Intrinsics.checkNotNullParameter((Object)lunarDay, (String)"lunarDay");
            return new FetusDay(lunarDay.getSixtyCycle());
        }

        @JvmStatic
        @NotNull
        public final FetusDay fromSixtyCycleDay(@NotNull SixtyCycleDay sixtyCycleDay) {
            Intrinsics.checkNotNullParameter((Object)sixtyCycleDay, (String)"sixtyCycleDay");
            return new FetusDay(sixtyCycleDay.getSixtyCycle());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

