/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.AbstractTyme;
import com.tyme.solar.SolarMonth;
import com.tyme.solar.SolarSeason;
import com.tyme.solar.SolarYear;
import java.util.ArrayList;
import java.util.List;

public class SolarHalfYear
extends AbstractTyme {
    public static final String[] NAMES = new String[]{"\u4e0a\u534a\u5e74", "\u4e0b\u534a\u5e74"};
    protected SolarYear year;
    protected int index;

    public SolarHalfYear(int year, int index) {
        if (index < 0 || index > 1) {
            throw new IllegalArgumentException(String.format("illegal solar half year index: %d", index));
        }
        this.year = SolarYear.fromYear(year);
        this.index = index;
    }

    public static SolarHalfYear fromIndex(int year, int index) {
        return new SolarHalfYear(year, index);
    }

    public SolarYear getSolarYear() {
        return this.year;
    }

    public int getYear() {
        return this.year.getYear();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return NAMES[this.index];
    }

    @Override
    public String toString() {
        return this.year + this.getName();
    }

    @Override
    public SolarHalfYear next(int n) {
        int i = this.index + n;
        return SolarHalfYear.fromIndex((this.getYear() * 2 + i) / 2, this.indexOf(i, 2));
    }

    public List<SolarMonth> getMonths() {
        ArrayList<SolarMonth> l = new ArrayList<SolarMonth>(6);
        int y = this.getYear();
        for (int i = 1; i < 7; ++i) {
            l.add(SolarMonth.fromYm(y, this.index * 6 + i));
        }
        return l;
    }

    public List<SolarSeason> getSeasons() {
        ArrayList<SolarSeason> l = new ArrayList<SolarSeason>(2);
        int y = this.getYear();
        for (int i = 0; i < 2; ++i) {
            l.add(SolarSeason.fromIndex(y, this.index * 2 + i));
        }
        return l;
    }
}

