/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.sixtycycle;

import com.tyme.AbstractTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.Twenty;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.sixtycycle.HeavenStem;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleMonth;
import java.util.ArrayList;
import java.util.List;

public class SixtyCycleYear
extends AbstractTyme {
    protected int year;

    public SixtyCycleYear(int year) {
        if (year < -1 || year > 9999) {
            throw new IllegalArgumentException(String.format("illegal sixty cycle year: %d", year));
        }
        this.year = year;
    }

    public static SixtyCycleYear fromYear(int year) {
        return new SixtyCycleYear(year);
    }

    public int getYear() {
        return this.year;
    }

    public SixtyCycle getSixtyCycle() {
        return SixtyCycle.fromIndex(this.year - 4);
    }

    @Override
    public String getName() {
        return String.format("%s\u5e74", this.getSixtyCycle());
    }

    public Twenty getTwenty() {
        return Twenty.fromIndex((int)Math.floor((double)(this.year - 1864) / 20.0));
    }

    public NineStar getNineStar() {
        return NineStar.fromIndex(63 + this.getTwenty().getSixty().getIndex() * 3 - this.getSixtyCycle().getIndex());
    }

    public Direction getJupiterDirection() {
        return Direction.fromIndex((new int[]{0, 7, 7, 2, 3, 3, 8, 1, 1, 6, 0, 0})[this.getSixtyCycle().getEarthBranch().getIndex()]);
    }

    @Override
    public SixtyCycleYear next(int n) {
        return SixtyCycleYear.fromYear(this.year + n);
    }

    public SixtyCycleMonth getFirstMonth() {
        HeavenStem h = HeavenStem.fromIndex((this.getSixtyCycle().getHeavenStem().getIndex() + 1) * 2);
        return new SixtyCycleMonth(this, SixtyCycle.fromName(h.getName() + "\u5bc5"));
    }

    public List<SixtyCycleMonth> getMonths() {
        ArrayList<SixtyCycleMonth> l = new ArrayList<SixtyCycleMonth>();
        SixtyCycleMonth m = this.getFirstMonth();
        l.add(m);
        for (int i = 1; i < 12; ++i) {
            l.add(m.next(i));
        }
        return l;
    }
}

