/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.sixtycycle;

import com.tyme.AbstractTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleDay;
import com.tyme.sixtycycle.SixtyCycleYear;
import com.tyme.solar.SolarTerm;
import java.util.ArrayList;
import java.util.List;

public class SixtyCycleMonth
extends AbstractTyme {
    protected SixtyCycleYear year;
    protected SixtyCycle month;

    public SixtyCycleMonth(SixtyCycleYear year, SixtyCycle month) {
        this.year = year;
        this.month = month;
    }

    public static SixtyCycleMonth fromIndex(int year, int index) {
        return SixtyCycleYear.fromYear(year).getFirstMonth().next(index);
    }

    public SixtyCycleYear getSixtyCycleYear() {
        return this.year;
    }

    public SixtyCycle getYear() {
        return this.year.getSixtyCycle();
    }

    public SixtyCycle getSixtyCycle() {
        return this.month;
    }

    @Override
    public String getName() {
        return String.format("%s\u6708", this.month);
    }

    @Override
    public String toString() {
        return String.format("%s%s", this.year, this.getName());
    }

    @Override
    public SixtyCycleMonth next(int n) {
        return new SixtyCycleMonth(SixtyCycleYear.fromYear((this.year.getYear() * 12 + this.getIndexInYear() + n) / 12), this.month.next(n));
    }

    public int getIndexInYear() {
        return this.month.getEarthBranch().next(-2).getIndex();
    }

    public NineStar getNineStar() {
        int index = this.month.getEarthBranch().getIndex();
        if (index < 2) {
            index += 3;
        }
        return NineStar.fromIndex(27 - this.getYear().getEarthBranch().getIndex() % 3 * 3 - index);
    }

    public Direction getJupiterDirection() {
        int n = (new int[]{7, -1, 1, 3})[this.month.getEarthBranch().next(-2).getIndex() % 4];
        return n == -1 ? this.month.getHeavenStem().getDirection() : Direction.fromIndex(n);
    }

    public SixtyCycleDay getFirstDay() {
        return SixtyCycleDay.fromSolarDay(SolarTerm.fromIndex(this.year.getYear(), 3 + this.getIndexInYear() * 2).getJulianDay().getSolarDay());
    }

    public List<SixtyCycleDay> getDays() {
        ArrayList<SixtyCycleDay> l = new ArrayList<SixtyCycleDay>();
        SixtyCycleDay d = this.getFirstDay();
        while (d.getSixtyCycleMonth().equals(this)) {
            l.add(d);
            d = d.next(1);
        }
        return l;
    }
}

