/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.sixtycycle;

import com.tyme.AbstractTyme;
import com.tyme.culture.Taboo;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.culture.star.twelve.TwelveStar;
import com.tyme.eightchar.EightChar;
import com.tyme.lunar.LunarDay;
import com.tyme.lunar.LunarHour;
import com.tyme.lunar.LunarMonth;
import com.tyme.lunar.LunarYear;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleDay;
import com.tyme.sixtycycle.SixtyCycleMonth;
import com.tyme.sixtycycle.SixtyCycleYear;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTerm;
import com.tyme.solar.SolarTime;
import java.util.List;

public class SixtyCycleHour
extends AbstractTyme {
    protected SolarTime solarTime;
    protected SixtyCycleDay day;
    protected SixtyCycle hour;

    public SixtyCycleHour(SolarTime solarTime) {
        SolarTerm term;
        int index;
        int solarYear = solarTime.getYear();
        SolarTime springSolarTime = SolarTerm.fromIndex(solarYear, 3).getJulianDay().getSolarTime();
        LunarHour lunarHour = solarTime.getLunarHour();
        LunarDay lunarDay = lunarHour.getLunarDay();
        LunarYear lunarYear = lunarDay.getLunarMonth().getLunarYear();
        if (lunarYear.getYear() == solarYear) {
            if (solarTime.isBefore(springSolarTime)) {
                lunarYear = lunarYear.next(-1);
            }
        } else if (lunarYear.getYear() < solarYear && !solarTime.isBefore(springSolarTime)) {
            lunarYear = lunarYear.next(1);
        }
        if ((index = (term = solarTime.getTerm()).getIndex() - 3) < 0 && term.getJulianDay().getSolarTime().isAfter(SolarTerm.fromIndex(solarYear, 3).getJulianDay().getSolarTime())) {
            index += 24;
        }
        SixtyCycle d = lunarDay.getSixtyCycle();
        this.solarTime = solarTime;
        this.day = new SixtyCycleDay(solarTime.getSolarDay(), new SixtyCycleMonth(SixtyCycleYear.fromYear(lunarYear.getYear()), LunarMonth.fromYm(solarYear, 1).getSixtyCycle().next((int)Math.floor((double)index * 1.0 / 2.0))), solarTime.getHour() < 23 ? d : d.next(1));
        this.hour = lunarHour.getSixtyCycle();
    }

    public static SixtyCycleHour fromSolarTime(SolarTime solarTime) {
        return new SixtyCycleHour(solarTime);
    }

    public SixtyCycle getYear() {
        return this.day.getYear();
    }

    public SixtyCycle getMonth() {
        return this.day.getMonth();
    }

    public SixtyCycle getDay() {
        return this.day.getSixtyCycle();
    }

    public SixtyCycle getSixtyCycle() {
        return this.hour;
    }

    public SixtyCycleDay getSixtyCycleDay() {
        return this.day;
    }

    public SolarTime getSolarTime() {
        return this.solarTime;
    }

    @Override
    public String getName() {
        return String.format("%s\u65f6", this.hour);
    }

    @Override
    public String toString() {
        return String.format("%s%s", this.day, this.getName());
    }

    public int getIndexInDay() {
        int h = this.solarTime.getHour();
        return h == 23 ? 0 : (h + 1) / 2;
    }

    public NineStar getNineStar() {
        SolarDay solar = this.solarTime.getSolarDay();
        SolarTerm dongZhi = SolarTerm.fromIndex(solar.getYear(), 0);
        SolarTerm xiaZhi = dongZhi.next(12);
        boolean asc = !solar.isBefore(dongZhi.getJulianDay().getSolarDay()) && solar.isBefore(xiaZhi.getJulianDay().getSolarDay());
        int start = (new int[]{8, 5, 2})[this.getDay().getEarthBranch().getIndex() % 3];
        if (asc) {
            start = 8 - start;
        }
        int earthBranchIndex = this.getIndexInDay() % 12;
        return NineStar.fromIndex(start + (asc ? earthBranchIndex : -earthBranchIndex));
    }

    public TwelveStar getTwelveStar() {
        return TwelveStar.fromIndex(this.hour.getEarthBranch().getIndex() + (8 - this.getDay().getEarthBranch().getIndex() % 6) * 2);
    }

    public List<Taboo> getRecommends() {
        return Taboo.getHourRecommends(this.getDay(), this.hour);
    }

    public List<Taboo> getAvoids() {
        return Taboo.getHourAvoids(this.getDay(), this.hour);
    }

    @Override
    public SixtyCycleHour next(int n) {
        return SixtyCycleHour.fromSolarTime(this.solarTime.next(n));
    }

    public EightChar getEightChar() {
        return new EightChar(this.getYear(), this.getMonth(), this.getDay(), this.hour);
    }
}

