/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.sixtycycle;

import com.tyme.AbstractTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.Duty;
import com.tyme.culture.Element;
import com.tyme.culture.God;
import com.tyme.culture.Taboo;
import com.tyme.culture.fetus.FetusDay;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.culture.star.twelve.TwelveStar;
import com.tyme.culture.star.twentyeight.TwentyEightStar;
import com.tyme.lunar.LunarDay;
import com.tyme.lunar.LunarMonth;
import com.tyme.lunar.LunarYear;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleHour;
import com.tyme.sixtycycle.SixtyCycleMonth;
import com.tyme.sixtycycle.SixtyCycleYear;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTerm;
import com.tyme.solar.SolarTime;
import java.util.ArrayList;
import java.util.List;

public class SixtyCycleDay
extends AbstractTyme {
    protected SolarDay solarDay;
    protected SixtyCycleMonth month;
    protected SixtyCycle day;

    SixtyCycleDay(SolarDay solarDay, SixtyCycleMonth month, SixtyCycle day) {
        this.solarDay = solarDay;
        this.month = month;
        this.day = day;
    }

    public SixtyCycleDay(SolarDay solarDay) {
        SolarTerm term;
        int index;
        int solarYear = solarDay.getYear();
        SolarDay springSolarDay = SolarTerm.fromIndex(solarYear, 3).getJulianDay().getSolarDay();
        LunarDay lunarDay = solarDay.getLunarDay();
        LunarYear lunarYear = lunarDay.getLunarMonth().getLunarYear();
        if (lunarYear.getYear() == solarYear) {
            if (solarDay.isBefore(springSolarDay)) {
                lunarYear = lunarYear.next(-1);
            }
        } else if (lunarYear.getYear() < solarYear && !solarDay.isBefore(springSolarDay)) {
            lunarYear = lunarYear.next(1);
        }
        if ((index = (term = solarDay.getTerm()).getIndex() - 3) < 0 && term.getJulianDay().getSolarDay().isAfter(springSolarDay)) {
            index += 24;
        }
        this.solarDay = solarDay;
        this.month = new SixtyCycleMonth(SixtyCycleYear.fromYear(lunarYear.getYear()), LunarMonth.fromYm(solarYear, 1).getSixtyCycle().next((int)Math.floor((double)index * 1.0 / 2.0)));
        this.day = lunarDay.getSixtyCycle();
    }

    public static SixtyCycleDay fromSolarDay(SolarDay solarDay) {
        return new SixtyCycleDay(solarDay);
    }

    public SolarDay getSolarDay() {
        return this.solarDay;
    }

    public SixtyCycleMonth getSixtyCycleMonth() {
        return this.month;
    }

    public SixtyCycle getYear() {
        return this.month.getYear();
    }

    public SixtyCycle getMonth() {
        return this.month.getSixtyCycle();
    }

    public SixtyCycle getSixtyCycle() {
        return this.day;
    }

    @Override
    public String getName() {
        return String.format("%s\u65e5", this.day);
    }

    @Override
    public String toString() {
        return String.format("%s%s", this.month, this.getName());
    }

    public Duty getDuty() {
        return Duty.fromIndex(this.day.getEarthBranch().getIndex() - this.getMonth().getEarthBranch().getIndex());
    }

    public TwelveStar getTwelveStar() {
        return TwelveStar.fromIndex(this.day.getEarthBranch().getIndex() + (8 - this.getMonth().getEarthBranch().getIndex() % 6) * 2);
    }

    public NineStar getNineStar() {
        SolarTerm dongZhi = SolarTerm.fromIndex(this.solarDay.getYear(), 0);
        SolarTerm xiaZhi = dongZhi.next(12);
        SolarTerm dongZhi2 = dongZhi.next(24);
        SolarDay dongZhiSolar = dongZhi.getJulianDay().getSolarDay();
        SolarDay xiaZhiSolar = xiaZhi.getJulianDay().getSolarDay();
        SolarDay dongZhiSolar2 = dongZhi2.getJulianDay().getSolarDay();
        int dongZhiIndex = dongZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int xiaZhiIndex = xiaZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int dongZhiIndex2 = dongZhiSolar2.getLunarDay().getSixtyCycle().getIndex();
        SolarDay solarShunBai = dongZhiSolar.next(dongZhiIndex > 29 ? 60 - dongZhiIndex : -dongZhiIndex);
        SolarDay solarShunBai2 = dongZhiSolar2.next(dongZhiIndex2 > 29 ? 60 - dongZhiIndex2 : -dongZhiIndex2);
        SolarDay solarNiZi = xiaZhiSolar.next(xiaZhiIndex > 29 ? 60 - xiaZhiIndex : -xiaZhiIndex);
        int offset = 0;
        if (!this.solarDay.isBefore(solarShunBai) && this.solarDay.isBefore(solarNiZi)) {
            offset = this.solarDay.subtract(solarShunBai);
        } else if (!this.solarDay.isBefore(solarNiZi) && this.solarDay.isBefore(solarShunBai2)) {
            offset = 8 - this.solarDay.subtract(solarNiZi);
        } else if (!this.solarDay.isBefore(solarShunBai2)) {
            offset = this.solarDay.subtract(solarShunBai2);
        } else if (this.solarDay.isBefore(solarShunBai)) {
            offset = 8 + solarShunBai.subtract(this.solarDay);
        }
        return NineStar.fromIndex(offset);
    }

    public Direction getJupiterDirection() {
        int index = this.day.getIndex();
        return index % 12 < 6 ? Element.fromIndex(index / 12).getDirection() : this.month.getSixtyCycleYear().getJupiterDirection();
    }

    public FetusDay getFetusDay() {
        return FetusDay.fromSixtyCycleDay(this);
    }

    public TwentyEightStar getTwentyEightStar() {
        return TwentyEightStar.fromIndex((new int[]{10, 18, 26, 6, 14, 22, 2})[this.solarDay.getWeek().getIndex()]).next(-7 * this.day.getEarthBranch().getIndex());
    }

    public List<God> getGods() {
        return God.getDayGods(this.getMonth(), this.day);
    }

    public List<Taboo> getRecommends() {
        return Taboo.getDayRecommends(this.getMonth(), this.day);
    }

    public List<Taboo> getAvoids() {
        return Taboo.getDayAvoids(this.getMonth(), this.day);
    }

    @Override
    public SixtyCycleDay next(int n) {
        return SixtyCycleDay.fromSolarDay(this.solarDay.next(n));
    }

    public List<SixtyCycleHour> getHours() {
        ArrayList<SixtyCycleHour> l = new ArrayList<SixtyCycleHour>();
        SolarDay d = this.solarDay.next(-1);
        SixtyCycleHour h = SixtyCycleHour.fromSolarTime(SolarTime.fromYmdHms(d.getYear(), d.getMonth(), d.getDay(), 23, 0, 0));
        l.add(h);
        for (int i = 0; i < 11; ++i) {
            h = h.next(7200);
            l.add(h);
        }
        return l;
    }
}

