/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.sixtycycle;

import com.tyme.LoopTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.Element;
import com.tyme.culture.Terrain;
import com.tyme.culture.pengzu.PengZuHeavenStem;
import com.tyme.culture.star.ten.TenStar;
import com.tyme.enums.YinYang;
import com.tyme.sixtycycle.EarthBranch;

public class HeavenStem
extends LoopTyme {
    public static final String[] NAMES = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};

    public HeavenStem(int index) {
        super(NAMES, index);
    }

    public HeavenStem(String name) {
        super(NAMES, name);
    }

    public static HeavenStem fromIndex(int index) {
        return new HeavenStem(index);
    }

    public static HeavenStem fromName(String name) {
        return new HeavenStem(name);
    }

    @Override
    public HeavenStem next(int n) {
        return HeavenStem.fromIndex(this.nextIndex(n));
    }

    public Element getElement() {
        return Element.fromIndex(this.index / 2);
    }

    public YinYang getYinYang() {
        return this.index % 2 == 0 ? YinYang.YANG : YinYang.YIN;
    }

    public TenStar getTenStar(HeavenStem target) {
        if (null == target) {
            return null;
        }
        int targetIndex = target.getIndex();
        int offset = targetIndex - this.index;
        if (this.index % 2 != 0 && targetIndex % 2 == 0) {
            offset += 2;
        }
        return TenStar.fromIndex(offset);
    }

    public Direction getDirection() {
        return this.getElement().getDirection();
    }

    public Direction getJoyDirection() {
        return Direction.fromIndex((new int[]{7, 5, 1, 8, 3})[this.index % 5]);
    }

    public Direction getYangDirection() {
        return Direction.fromIndex((new int[]{1, 1, 6, 5, 7, 0, 8, 7, 2, 3})[this.index]);
    }

    public Direction getYinDirection() {
        return Direction.fromIndex((new int[]{7, 0, 5, 6, 1, 1, 7, 8, 3, 2})[this.index]);
    }

    public Direction getWealthDirection() {
        return Direction.fromIndex((new int[]{7, 1, 0, 2, 8})[this.index / 2]);
    }

    public Direction getMascotDirection() {
        return Direction.fromIndex((new int[]{3, 3, 2, 2, 0, 8, 1, 1, 5, 6})[this.index]);
    }

    public PengZuHeavenStem getPengZuHeavenStem() {
        return PengZuHeavenStem.fromIndex(this.index);
    }

    public Terrain getTerrain(EarthBranch earthBranch) {
        int earthBranchIndex = earthBranch.getIndex();
        return Terrain.fromIndex((new int[]{1, 6, 10, 9, 10, 9, 7, 0, 4, 3})[this.index] + (YinYang.YANG == this.getYinYang() ? earthBranchIndex : -earthBranchIndex));
    }

    public HeavenStem getCombine() {
        return this.next(5);
    }

    public Element combine(HeavenStem target) {
        return this.getCombine().equals(target) ? Element.fromIndex(this.index + 2) : null;
    }
}

