/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.sixtycycle;

import com.tyme.LoopTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.Element;
import com.tyme.culture.Zodiac;
import com.tyme.culture.pengzu.PengZuEarthBranch;
import com.tyme.enums.HideHeavenStemType;
import com.tyme.enums.YinYang;
import com.tyme.sixtycycle.HeavenStem;
import com.tyme.sixtycycle.HideHeavenStem;
import java.util.ArrayList;
import java.util.List;

public class EarthBranch
extends LoopTyme {
    public static final String[] NAMES = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};

    public EarthBranch(int index) {
        super(NAMES, index);
    }

    public EarthBranch(String name) {
        super(NAMES, name);
    }

    public static EarthBranch fromIndex(int index) {
        return new EarthBranch(index);
    }

    public static EarthBranch fromName(String name) {
        return new EarthBranch(name);
    }

    @Override
    public EarthBranch next(int n) {
        return EarthBranch.fromIndex(this.nextIndex(n));
    }

    public Element getElement() {
        return Element.fromIndex((new int[]{4, 2, 0, 0, 2, 1, 1, 2, 3, 3, 2, 4})[this.index]);
    }

    public YinYang getYinYang() {
        return this.index % 2 == 0 ? YinYang.YANG : YinYang.YIN;
    }

    public HeavenStem getHideHeavenStemMain() {
        return HeavenStem.fromIndex((new int[]{9, 5, 0, 1, 4, 2, 3, 5, 6, 7, 4, 8})[this.index]);
    }

    public HeavenStem getHideHeavenStemMiddle() {
        int n = (new int[]{-1, 9, 2, -1, 1, 6, 5, 3, 8, -1, 7, 0})[this.index];
        return n == -1 ? null : HeavenStem.fromIndex(n);
    }

    public HeavenStem getHideHeavenStemResidual() {
        int n = (new int[]{-1, 7, 4, -1, 9, 4, -1, 1, 4, -1, 3, -1})[this.index];
        return n == -1 ? null : HeavenStem.fromIndex(n);
    }

    public List<HideHeavenStem> getHideHeavenStems() {
        ArrayList<HideHeavenStem> l = new ArrayList<HideHeavenStem>();
        l.add(new HideHeavenStem(this.getHideHeavenStemMain(), HideHeavenStemType.MAIN));
        HeavenStem o = this.getHideHeavenStemMiddle();
        if (null != o) {
            l.add(new HideHeavenStem(o, HideHeavenStemType.MIDDLE));
        }
        if (null != (o = this.getHideHeavenStemResidual())) {
            l.add(new HideHeavenStem(o, HideHeavenStemType.RESIDUAL));
        }
        return l;
    }

    public Zodiac getZodiac() {
        return Zodiac.fromIndex(this.index);
    }

    public Direction getDirection() {
        return Direction.fromIndex((new int[]{0, 4, 2, 2, 4, 8, 8, 4, 6, 6, 4, 0})[this.index]);
    }

    public Direction getOminous() {
        return Direction.fromIndex((new int[]{8, 2, 0, 6})[this.index % 4]);
    }

    public PengZuEarthBranch getPengZuEarthBranch() {
        return PengZuEarthBranch.fromIndex(this.index);
    }

    public EarthBranch getOpposite() {
        return this.next(6);
    }

    public EarthBranch getCombine() {
        return EarthBranch.fromIndex(1 - this.index);
    }

    public EarthBranch getHarm() {
        return EarthBranch.fromIndex(19 - this.index);
    }

    public Element combine(EarthBranch target) {
        return this.getCombine().equals(target) ? Element.fromIndex((new int[]{2, 2, 0, 1, 3, 4, 2, 2, 4, 3, 1, 0})[this.index]) : null;
    }
}

