/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.rabbyung;

import com.tyme.AbstractTyme;
import com.tyme.culture.Zodiac;
import com.tyme.rabbyung.RabByungElement;
import com.tyme.rabbyung.RabByungMonth;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.solar.SolarYear;
import java.util.ArrayList;
import java.util.List;

public class RabByungYear
extends AbstractTyme {
    protected int rabByungIndex;
    protected SixtyCycle sixtyCycle;

    public RabByungYear(int rabByungIndex, SixtyCycle sixtyCycle) {
        if (rabByungIndex < 0 || rabByungIndex > 150) {
            throw new IllegalArgumentException(String.format("illegal rab-byung index: %d", rabByungIndex));
        }
        this.rabByungIndex = rabByungIndex;
        this.sixtyCycle = sixtyCycle;
    }

    public static RabByungYear fromSixtyCycle(int rabByungIndex, SixtyCycle sixtyCycle) {
        return new RabByungYear(rabByungIndex, sixtyCycle);
    }

    public static RabByungYear fromElementZodiac(int rabByungIndex, RabByungElement element, Zodiac zodiac) {
        for (int i = 0; i < 60; ++i) {
            SixtyCycle sixtyCycle = SixtyCycle.fromIndex(i);
            if (!sixtyCycle.getEarthBranch().getZodiac().equals(zodiac) || sixtyCycle.getHeavenStem().getElement().getIndex() != element.getIndex()) continue;
            return new RabByungYear(rabByungIndex, sixtyCycle);
        }
        throw new IllegalArgumentException(String.format("illegal rab-byung element %s, zodiac %s", element, zodiac));
    }

    public static RabByungYear fromYear(int year) {
        return new RabByungYear((year - 1024) / 60, SixtyCycle.fromIndex(year - 4));
    }

    public int getRabByungIndex() {
        return this.rabByungIndex;
    }

    public SixtyCycle getSixtyCycle() {
        return this.sixtyCycle;
    }

    public Zodiac getZodiac() {
        return this.getSixtyCycle().getEarthBranch().getZodiac();
    }

    public RabByungElement getElement() {
        return RabByungElement.fromIndex(this.getSixtyCycle().getHeavenStem().getElement().getIndex());
    }

    @Override
    public String getName() {
        String[] digits = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        String[] units = new String[]{"", "\u5341", "\u767e"};
        int n = this.rabByungIndex + 1;
        StringBuilder s = new StringBuilder();
        int pos = 0;
        while (n > 0) {
            int digit = n % 10;
            if (digit > 0) {
                s.insert(0, digits[digit] + units[pos]);
            } else if (s.length() > 0) {
                s.insert(0, digits[digit]);
            }
            n /= 10;
            ++pos;
        }
        String letter = s.toString();
        if (letter.startsWith("\u4e00\u5341")) {
            letter = letter.substring(1);
        }
        return String.format("\u7b2c%s\u9976\u8fe5%s%s\u5e74", letter, this.getElement(), this.getZodiac());
    }

    @Override
    public RabByungYear next(int n) {
        return RabByungYear.fromYear(this.getYear() + n);
    }

    public int getYear() {
        return 1024 + this.rabByungIndex * 60 + this.getSixtyCycle().getIndex();
    }

    public int getLeapMonth() {
        int y = 1;
        int m = 4;
        int t = 0;
        int currentYear = this.getYear();
        while (y < currentYear) {
            int i = m - 1 + (t % 2 == 0 ? 33 : 32);
            y = (y * 12 + i) / 12;
            m = i % 12 + 1;
            ++t;
        }
        return y == currentYear ? m : 0;
    }

    public SolarYear getSolarYear() {
        return SolarYear.fromYear(this.getYear());
    }

    public RabByungMonth getFirstMonth() {
        return new RabByungMonth(this, 1);
    }

    public int getMonthCount() {
        return this.getLeapMonth() < 1 ? 12 : 13;
    }

    public List<RabByungMonth> getMonths() {
        ArrayList<RabByungMonth> l = new ArrayList<RabByungMonth>();
        int leapMonth = this.getLeapMonth();
        for (int i = 1; i < 13; ++i) {
            l.add(new RabByungMonth(this, i));
            if (i != leapMonth) continue;
            l.add(new RabByungMonth(this, -i));
        }
        return l;
    }
}

