/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.lunar;

import com.tyme.AbstractTyme;
import com.tyme.culture.Week;
import com.tyme.lunar.LunarDay;
import com.tyme.lunar.LunarMonth;
import java.util.ArrayList;
import java.util.List;

public class LunarWeek
extends AbstractTyme {
    public static final String[] NAMES = new String[]{"\u7b2c\u4e00\u5468", "\u7b2c\u4e8c\u5468", "\u7b2c\u4e09\u5468", "\u7b2c\u56db\u5468", "\u7b2c\u4e94\u5468", "\u7b2c\u516d\u5468"};
    protected LunarMonth month;
    protected int index;
    protected Week start;

    public LunarWeek(int year, int month, int index, int start) {
        if (index < 0 || index > 5) {
            throw new IllegalArgumentException(String.format("illegal lunar week index: %d", index));
        }
        if (start < 0 || start > 6) {
            throw new IllegalArgumentException(String.format("illegal lunar week start: %d", start));
        }
        LunarMonth m = LunarMonth.fromYm(year, month);
        if (index >= m.getWeekCount(start)) {
            throw new IllegalArgumentException(String.format("illegal lunar week index: %d in month: %s", index, m));
        }
        this.month = m;
        this.index = index;
        this.start = Week.fromIndex(start);
    }

    public static LunarWeek fromYm(int year, int month, int index, int start) {
        return new LunarWeek(year, month, index, start);
    }

    public LunarMonth getLunarMonth() {
        return this.month;
    }

    public int getYear() {
        return this.month.getYear();
    }

    public int getMonth() {
        return this.month.getMonthWithLeap();
    }

    public int getIndex() {
        return this.index;
    }

    public Week getStart() {
        return this.start;
    }

    @Override
    public String getName() {
        return NAMES[this.index];
    }

    @Override
    public String toString() {
        return this.month + this.getName();
    }

    @Override
    public LunarWeek next(int n) {
        int d;
        int startIndex = this.start.getIndex();
        if (n == 0) {
            return LunarWeek.fromYm(this.getYear(), this.getMonth(), this.index, startIndex);
        }
        LunarMonth m = this.month;
        if (n > 0) {
            int weekCount = m.getWeekCount(startIndex);
            while (d >= weekCount) {
                d -= weekCount;
                if (!LunarDay.fromYmd((m = m.next(1)).getYear(), m.getMonthWithLeap(), 1).getWeek().equals(this.start)) {
                    ++d;
                }
                weekCount = m.getWeekCount(startIndex);
            }
        } else {
            for (d = this.index + n; d < 0; d += m.getWeekCount(startIndex)) {
                if (!LunarDay.fromYmd(m.getYear(), m.getMonthWithLeap(), 1).getWeek().equals(this.start)) {
                    --d;
                }
                m = m.next(-1);
            }
        }
        return LunarWeek.fromYm(m.getYear(), m.getMonthWithLeap(), d, startIndex);
    }

    public LunarDay getFirstDay() {
        LunarDay firstDay = LunarDay.fromYmd(this.getYear(), this.getMonth(), 1);
        return firstDay.next(this.index * 7 - this.indexOf(firstDay.getWeek().getIndex() - this.start.getIndex(), 7));
    }

    public List<LunarDay> getDays() {
        ArrayList<LunarDay> l = new ArrayList<LunarDay>(7);
        LunarDay d = this.getFirstDay();
        l.add(d);
        for (int i = 1; i < 7; ++i) {
            l.add(d.next(i));
        }
        return l;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof LunarWeek && this.getFirstDay().equals(((LunarWeek)o).getFirstDay());
    }
}

