/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.lunar;

import com.tyme.AbstractTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.fetus.FetusMonth;
import com.tyme.culture.ren.MinorRen;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.jd.JulianDay;
import com.tyme.lunar.LunarDay;
import com.tyme.lunar.LunarSeason;
import com.tyme.lunar.LunarWeek;
import com.tyme.lunar.LunarYear;
import com.tyme.sixtycycle.EarthBranch;
import com.tyme.sixtycycle.HeavenStem;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.solar.SolarTerm;
import com.tyme.util.ShouXingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LunarMonth
extends AbstractTyme {
    private static final Map<String, Object[]> cache = new HashMap<String, Object[]>();
    public static final String[] NAMES = new String[]{"\u6b63\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
    protected LunarYear year;
    protected int month;
    protected boolean leap;
    protected int dayCount;
    protected int indexInYear;
    protected JulianDay firstJulianDay;

    protected LunarMonth(Object[] cache) {
        int m = (Integer)cache[1];
        this.year = LunarYear.fromYear((Integer)cache[0]);
        this.month = Math.abs(m);
        this.leap = m < 0;
        this.dayCount = (Integer)cache[2];
        this.indexInYear = (Integer)cache[3];
        this.firstJulianDay = JulianDay.fromJulianDay((Double)cache[4]);
    }

    public LunarMonth(int year, int month) {
        LunarYear currentYear = LunarYear.fromYear(year);
        int currentLeapMonth = currentYear.getLeapMonth();
        if (month == 0 || month > 12 || month < -12) {
            throw new IllegalArgumentException(String.format("illegal lunar month: %d", month));
        }
        boolean leap = month < 0;
        int m = Math.abs(month);
        if (leap && m != currentLeapMonth) {
            throw new IllegalArgumentException(String.format("illegal leap month %d in lunar year %d", m, year));
        }
        SolarTerm dongZhi = SolarTerm.fromIndex(year, 0);
        double dongZhiJd = dongZhi.getCursoryJulianDay();
        double w = ShouXingUtil.calcShuo(dongZhiJd);
        if (w > dongZhiJd) {
            w -= 29.53;
        }
        int offset = 2;
        if (year > 8 && year < 24) {
            offset = 1;
        } else if (LunarYear.fromYear(year - 1).getLeapMonth() > 10 && year != 239 && year != 240) {
            offset = 3;
        }
        int index = m - 1;
        if (leap || currentLeapMonth > 0 && m > currentLeapMonth) {
            ++index;
        }
        this.indexInYear = index;
        double firstDay = ShouXingUtil.calcShuo(w += 29.5306 * (double)(offset + index));
        this.firstJulianDay = JulianDay.fromJulianDay(2451545.0 + firstDay);
        this.dayCount = (int)(ShouXingUtil.calcShuo(w + 29.5306) - firstDay);
        this.year = currentYear;
        this.month = m;
        this.leap = leap;
    }

    public static LunarMonth fromYm(int year, int month) {
        LunarMonth m;
        String key = String.format("%d%d", year, month);
        Object[] c = cache.get(key);
        if (null != c) {
            m = new LunarMonth(c);
        } else {
            m = new LunarMonth(year, month);
            cache.put(key, new Object[]{m.getYear(), m.getMonthWithLeap(), m.getDayCount(), m.getIndexInYear(), m.getFirstJulianDay().getDay()});
        }
        return m;
    }

    public LunarYear getLunarYear() {
        return this.year;
    }

    public int getYear() {
        return this.year.getYear();
    }

    public int getMonth() {
        return this.month;
    }

    public int getMonthWithLeap() {
        return this.leap ? -this.month : this.month;
    }

    public int getDayCount() {
        return this.dayCount;
    }

    public int getIndexInYear() {
        return this.indexInYear;
    }

    public LunarSeason getSeason() {
        return LunarSeason.fromIndex(this.month - 1);
    }

    public JulianDay getFirstJulianDay() {
        return this.firstJulianDay;
    }

    public boolean isLeap() {
        return this.leap;
    }

    public int getWeekCount(int start) {
        return (int)Math.ceil((double)(this.indexOf(this.firstJulianDay.getWeek().getIndex() - start, 7) + this.getDayCount()) / 7.0);
    }

    @Override
    public String getName() {
        return (this.leap ? "\u95f0" : "") + NAMES[this.month - 1];
    }

    @Override
    public String toString() {
        return this.year + this.getName();
    }

    @Override
    public LunarMonth next(int n) {
        int m;
        if (n == 0) {
            return LunarMonth.fromYm(this.getYear(), this.getMonthWithLeap());
        }
        LunarYear y = this.year;
        if (n > 0) {
            int monthCount = y.getMonthCount();
            while (m > monthCount) {
                m -= monthCount;
                y = y.next(1);
                monthCount = y.getMonthCount();
            }
        } else {
            for (m = this.indexInYear + 1 + n; m <= 0; m += y.getMonthCount()) {
                y = y.next(-1);
            }
        }
        boolean leap = false;
        int leapMonth = y.getLeapMonth();
        if (leapMonth > 0) {
            if (m == leapMonth + 1) {
                leap = true;
            }
            if (m > leapMonth) {
                --m;
            }
        }
        return LunarMonth.fromYm(y.getYear(), leap ? -m : m);
    }

    public List<LunarDay> getDays() {
        int size = this.getDayCount();
        int y = this.getYear();
        int m = this.getMonthWithLeap();
        ArrayList<LunarDay> l = new ArrayList<LunarDay>(size);
        for (int i = 1; i <= size; ++i) {
            l.add(LunarDay.fromYmd(y, m, i));
        }
        return l;
    }

    public List<LunarWeek> getWeeks(int start) {
        int size = this.getWeekCount(start);
        int y = this.getYear();
        int m = this.getMonthWithLeap();
        ArrayList<LunarWeek> l = new ArrayList<LunarWeek>(size);
        for (int i = 0; i < size; ++i) {
            l.add(LunarWeek.fromYm(y, m, i, start));
        }
        return l;
    }

    public SixtyCycle getSixtyCycle() {
        return SixtyCycle.fromName(HeavenStem.fromIndex((this.year.getSixtyCycle().getHeavenStem().getIndex() + 1) * 2 + this.indexInYear).getName() + EarthBranch.fromIndex(this.indexInYear + 2).getName());
    }

    public NineStar getNineStar() {
        int index = this.getSixtyCycle().getEarthBranch().getIndex();
        if (index < 2) {
            index += 3;
        }
        return NineStar.fromIndex(27 - this.year.getSixtyCycle().getEarthBranch().getIndex() % 3 * 3 - index);
    }

    public Direction getJupiterDirection() {
        SixtyCycle sixtyCycle = this.getSixtyCycle();
        int n = (new int[]{7, -1, 1, 3})[sixtyCycle.getEarthBranch().next(-2).getIndex() % 4];
        return n == -1 ? sixtyCycle.getHeavenStem().getDirection() : Direction.fromIndex(n);
    }

    public FetusMonth getFetus() {
        return FetusMonth.fromLunarMonth(this);
    }

    public MinorRen getMinorRen() {
        return MinorRen.fromIndex((this.month - 1) % 6);
    }
}

