/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.lunar;

import com.tyme.AbstractTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.Duty;
import com.tyme.culture.Element;
import com.tyme.culture.God;
import com.tyme.culture.Phase;
import com.tyme.culture.Taboo;
import com.tyme.culture.Week;
import com.tyme.culture.fetus.FetusDay;
import com.tyme.culture.ren.MinorRen;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.culture.star.six.SixStar;
import com.tyme.culture.star.twelve.TwelveStar;
import com.tyme.culture.star.twentyeight.TwentyEightStar;
import com.tyme.festival.LunarFestival;
import com.tyme.lunar.LunarHour;
import com.tyme.lunar.LunarMonth;
import com.tyme.sixtycycle.EarthBranch;
import com.tyme.sixtycycle.HeavenStem;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleDay;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTerm;
import java.util.ArrayList;
import java.util.List;

public class LunarDay
extends AbstractTyme {
    public static final String[] NAMES = new String[]{"\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u4e09\u5341"};
    protected LunarMonth month;
    protected int day;
    protected SolarDay solarDay;
    protected SixtyCycleDay sixtyCycleDay;

    public LunarDay(int year, int month, int day) {
        LunarMonth m = LunarMonth.fromYm(year, month);
        if (day < 1 || day > m.getDayCount()) {
            throw new IllegalArgumentException(String.format("illegal day %d in %s", day, m));
        }
        this.month = m;
        this.day = day;
    }

    public static LunarDay fromYmd(int year, int month, int day) {
        return new LunarDay(year, month, day);
    }

    public LunarMonth getLunarMonth() {
        return this.month;
    }

    public int getYear() {
        return this.month.getYear();
    }

    public int getMonth() {
        return this.month.getMonthWithLeap();
    }

    public int getDay() {
        return this.day;
    }

    @Override
    public String getName() {
        return NAMES[this.day - 1];
    }

    @Override
    public String toString() {
        return this.month + this.getName();
    }

    @Override
    public LunarDay next(int n) {
        return this.getSolarDay().next(n).getLunarDay();
    }

    public boolean isBefore(LunarDay target) {
        int bMonth;
        int bYear;
        int aYear = this.getYear();
        if (aYear != (bYear = target.getYear())) {
            return aYear < bYear;
        }
        int aMonth = this.getMonth();
        if (aMonth != (bMonth = target.getMonth())) {
            return Math.abs(aMonth) < Math.abs(bMonth);
        }
        return this.day < target.getDay();
    }

    public boolean isAfter(LunarDay target) {
        int bMonth;
        int bYear;
        int aYear = this.getYear();
        if (aYear != (bYear = target.getYear())) {
            return aYear > bYear;
        }
        int aMonth = this.getMonth();
        if (aMonth != (bMonth = target.getMonth())) {
            return Math.abs(aMonth) >= Math.abs(bMonth);
        }
        return this.day > target.getDay();
    }

    public Week getWeek() {
        return this.getSolarDay().getWeek();
    }

    @Deprecated
    public SixtyCycle getYearSixtyCycle() {
        return this.getSixtyCycleDay().getYear();
    }

    @Deprecated
    public SixtyCycle getMonthSixtyCycle() {
        return this.getSixtyCycleDay().getMonth();
    }

    public SixtyCycle getSixtyCycle() {
        int offset = (int)this.month.getFirstJulianDay().next(this.day - 12).getDay();
        return SixtyCycle.fromName(HeavenStem.fromIndex(offset).getName() + EarthBranch.fromIndex(offset).getName());
    }

    public Duty getDuty() {
        return this.getSixtyCycleDay().getDuty();
    }

    public TwelveStar getTwelveStar() {
        return this.getSixtyCycleDay().getTwelveStar();
    }

    public NineStar getNineStar() {
        SolarDay d = this.getSolarDay();
        SolarTerm dongZhi = SolarTerm.fromIndex(d.getYear(), 0);
        SolarTerm xiaZhi = dongZhi.next(12);
        SolarTerm dongZhi2 = dongZhi.next(24);
        SolarDay dongZhiSolar = dongZhi.getJulianDay().getSolarDay();
        SolarDay xiaZhiSolar = xiaZhi.getJulianDay().getSolarDay();
        SolarDay dongZhiSolar2 = dongZhi2.getJulianDay().getSolarDay();
        int dongZhiIndex = dongZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int xiaZhiIndex = xiaZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int dongZhiIndex2 = dongZhiSolar2.getLunarDay().getSixtyCycle().getIndex();
        SolarDay solarShunBai = dongZhiSolar.next(dongZhiIndex > 29 ? 60 - dongZhiIndex : -dongZhiIndex);
        SolarDay solarShunBai2 = dongZhiSolar2.next(dongZhiIndex2 > 29 ? 60 - dongZhiIndex2 : -dongZhiIndex2);
        SolarDay solarNiZi = xiaZhiSolar.next(xiaZhiIndex > 29 ? 60 - xiaZhiIndex : -xiaZhiIndex);
        int offset = 0;
        if (!d.isBefore(solarShunBai) && d.isBefore(solarNiZi)) {
            offset = d.subtract(solarShunBai);
        } else if (!d.isBefore(solarNiZi) && d.isBefore(solarShunBai2)) {
            offset = 8 - d.subtract(solarNiZi);
        } else if (!d.isBefore(solarShunBai2)) {
            offset = d.subtract(solarShunBai2);
        } else if (d.isBefore(solarShunBai)) {
            offset = 8 + solarShunBai.subtract(d);
        }
        return NineStar.fromIndex(offset);
    }

    public Direction getJupiterDirection() {
        int index = this.getSixtyCycle().getIndex();
        return index % 12 < 6 ? Element.fromIndex(index / 12).getDirection() : this.month.getLunarYear().getJupiterDirection();
    }

    public FetusDay getFetusDay() {
        return FetusDay.fromLunarDay(this);
    }

    public Phase getPhase() {
        return Phase.fromIndex(this.day - 1);
    }

    public SixStar getSixStar() {
        return SixStar.fromIndex((this.month.getMonth() + this.day - 2) % 6);
    }

    public SolarDay getSolarDay() {
        if (null == this.solarDay) {
            this.solarDay = this.month.getFirstJulianDay().next(this.day - 1).getSolarDay();
        }
        return this.solarDay;
    }

    public SixtyCycleDay getSixtyCycleDay() {
        if (null == this.sixtyCycleDay) {
            this.sixtyCycleDay = this.getSolarDay().getSixtyCycleDay();
        }
        return this.sixtyCycleDay;
    }

    public TwentyEightStar getTwentyEightStar() {
        return TwentyEightStar.fromIndex((new int[]{10, 18, 26, 6, 14, 22, 2})[this.getSolarDay().getWeek().getIndex()]).next(-7 * this.getSixtyCycle().getEarthBranch().getIndex());
    }

    public LunarFestival getFestival() {
        return LunarFestival.fromYmd(this.getYear(), this.getMonth(), this.day);
    }

    public List<LunarHour> getHours() {
        ArrayList<LunarHour> l = new ArrayList<LunarHour>();
        int y = this.getYear();
        int m = this.getMonth();
        l.add(LunarHour.fromYmdHms(y, m, this.day, 0, 0, 0));
        for (int i = 0; i < 24; i += 2) {
            l.add(LunarHour.fromYmdHms(y, m, this.day, i + 1, 0, 0));
        }
        return l;
    }

    public List<God> getGods() {
        return this.getSixtyCycleDay().getGods();
    }

    public List<Taboo> getRecommends() {
        return this.getSixtyCycleDay().getRecommends();
    }

    public List<Taboo> getAvoids() {
        return this.getSixtyCycleDay().getAvoids();
    }

    public MinorRen getMinorRen() {
        return this.getLunarMonth().getMinorRen().next(this.day - 1);
    }
}

