/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.festival;

import com.tyme.AbstractTyme;
import com.tyme.enums.FestivalType;
import com.tyme.lunar.LunarDay;
import com.tyme.solar.SolarTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LunarFestival
extends AbstractTyme {
    public static final String[] NAMES = new String[]{"\u6625\u8282", "\u5143\u5bb5\u8282", "\u9f99\u5934\u8282", "\u4e0a\u5df3\u8282", "\u6e05\u660e\u8282", "\u7aef\u5348\u8282", "\u4e03\u5915\u8282", "\u4e2d\u5143\u8282", "\u4e2d\u79cb\u8282", "\u91cd\u9633\u8282", "\u51ac\u81f3\u8282", "\u814a\u516b\u8282", "\u9664\u5915"};
    public static String DATA = "@0000101@0100115@0200202@0300303@04107@0500505@0600707@0700715@0800815@0900909@10124@1101208@122";
    protected FestivalType type;
    protected int index;
    protected LunarDay day;
    protected SolarTerm solarTerm;
    protected String name;

    public LunarFestival(FestivalType type, LunarDay day, SolarTerm solarTerm, String data) {
        this.type = type;
        this.day = day;
        this.solarTerm = solarTerm;
        this.index = Integer.parseInt(data.substring(1, 3), 10);
        this.name = NAMES[this.index];
    }

    public static LunarFestival fromIndex(int year, int index) {
        if (index < 0 || index >= NAMES.length) {
            throw new IllegalArgumentException(String.format("illegal index: %d", index));
        }
        Matcher matcher = Pattern.compile(String.format("@%02d\\d+", index)).matcher(DATA);
        if (!matcher.find()) {
            return null;
        }
        String data = matcher.group();
        FestivalType type = FestivalType.fromCode(data.charAt(3) - 48);
        switch (type) {
            case DAY: {
                return new LunarFestival(type, LunarDay.fromYmd(year, Integer.parseInt(data.substring(4, 6), 10), Integer.parseInt(data.substring(6), 10)), null, data);
            }
            case TERM: {
                SolarTerm solarTerm = SolarTerm.fromIndex(year, Integer.parseInt(data.substring(4), 10));
                return new LunarFestival(type, solarTerm.getJulianDay().getSolarDay().getLunarDay(), solarTerm, data);
            }
            case EVE: {
                return new LunarFestival(type, LunarDay.fromYmd(year + 1, 1, 1).next(-1), null, data);
            }
        }
        return null;
    }

    public static LunarFestival fromYmd(int year, int month, int day) {
        Matcher matcher = Pattern.compile(String.format("@\\d{2}0%02d%02d", month, day)).matcher(DATA);
        if (matcher.find()) {
            return new LunarFestival(FestivalType.DAY, LunarDay.fromYmd(year, month, day), null, matcher.group());
        }
        matcher = Pattern.compile("@\\d{2}1\\d{2}").matcher(DATA);
        while (matcher.find()) {
            String data = matcher.group();
            SolarTerm solarTerm = SolarTerm.fromIndex(year, Integer.parseInt(data.substring(4), 10));
            LunarDay lunarDay = solarTerm.getJulianDay().getSolarDay().getLunarDay();
            if (lunarDay.getYear() != year || lunarDay.getMonth() != month || lunarDay.getDay() != day) continue;
            return new LunarFestival(FestivalType.TERM, lunarDay, solarTerm, data);
        }
        matcher = Pattern.compile("@\\d{2}2").matcher(DATA);
        if (!matcher.find()) {
            return null;
        }
        LunarDay lunarDay = LunarDay.fromYmd(year, month, day);
        LunarDay nextDay = lunarDay.next(1);
        return nextDay.getMonth() == 1 && nextDay.getDay() == 1 ? new LunarFestival(FestivalType.EVE, lunarDay, null, matcher.group()) : null;
    }

    @Override
    public LunarFestival next(int n) {
        int size = NAMES.length;
        int i = this.index + n;
        return LunarFestival.fromIndex((this.day.getYear() * size + i) / size, this.indexOf(i, size));
    }

    public FestivalType getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public LunarDay getDay() {
        return this.day;
    }

    public SolarTerm getSolarTerm() {
        return this.solarTerm;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return String.format("%s %s", this.day, this.name);
    }
}

