/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.eightchar;

import com.tyme.AbstractTyme;
import com.tyme.eightchar.ChildLimit;
import com.tyme.lunar.LunarYear;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleYear;

public class Fortune
extends AbstractTyme {
    protected ChildLimit childLimit;
    protected int index;

    public Fortune(ChildLimit childLimit, int index) {
        this.childLimit = childLimit;
        this.index = index;
    }

    public static Fortune fromChildLimit(ChildLimit childLimit, int index) {
        return new Fortune(childLimit, index);
    }

    public int getAge() {
        return this.childLimit.getEndSixtyCycleYear().getYear() - this.childLimit.getStartSixtyCycleYear().getYear() + 1 + this.index;
    }

    @Deprecated
    public LunarYear getLunarYear() {
        return this.childLimit.getEndLunarYear().next(this.index);
    }

    public SixtyCycleYear getSixtyCycleYear() {
        return this.childLimit.getEndSixtyCycleYear().next(this.index);
    }

    public SixtyCycle getSixtyCycle() {
        int n = this.getAge();
        return this.childLimit.getEightChar().getHour().next(this.childLimit.isForward() ? n : -n);
    }

    @Override
    public String getName() {
        return this.getSixtyCycle().getName();
    }

    @Override
    public Fortune next(int n) {
        return Fortune.fromChildLimit(this.childLimit, this.index + n);
    }
}

