/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.eightchar;

import com.tyme.AbstractCulture;
import com.tyme.culture.Duty;
import com.tyme.sixtycycle.EarthBranch;
import com.tyme.sixtycycle.HeavenStem;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTerm;
import com.tyme.solar.SolarTime;
import java.util.ArrayList;
import java.util.List;

public class EightChar
extends AbstractCulture {
    protected SixtyCycle year;
    protected SixtyCycle month;
    protected SixtyCycle day;
    protected SixtyCycle hour;

    public EightChar(SixtyCycle year, SixtyCycle month, SixtyCycle day, SixtyCycle hour) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
    }

    public EightChar(String year, String month, String day, String hour) {
        this(SixtyCycle.fromName(year), SixtyCycle.fromName(month), SixtyCycle.fromName(day), SixtyCycle.fromName(hour));
    }

    public SixtyCycle getYear() {
        return this.year;
    }

    public SixtyCycle getMonth() {
        return this.month;
    }

    public SixtyCycle getDay() {
        return this.day;
    }

    public SixtyCycle getHour() {
        return this.hour;
    }

    public SixtyCycle getFetalOrigin() {
        return SixtyCycle.fromName(this.month.getHeavenStem().next(1).getName() + this.month.getEarthBranch().next(3).getName());
    }

    public SixtyCycle getFetalBreath() {
        return SixtyCycle.fromName(this.day.getHeavenStem().next(5).getName() + EarthBranch.fromIndex(13 - this.day.getEarthBranch().getIndex()).getName());
    }

    public SixtyCycle getOwnSign() {
        int offset;
        int h;
        int m = this.month.getEarthBranch().getIndex() - 1;
        if (m < 1) {
            m += 12;
        }
        if ((h = this.hour.getEarthBranch().getIndex() - 1) < 1) {
            h += 12;
        }
        offset = ((offset = m + h) >= 14 ? 26 : 14) - offset;
        return SixtyCycle.fromName(HeavenStem.fromIndex((this.year.getHeavenStem().getIndex() + 1) * 2 + offset - 1).getName() + EarthBranch.fromIndex(offset + 1).getName());
    }

    public SixtyCycle getBodySign() {
        int h;
        int offset;
        int m = this.month.getEarthBranch().getIndex() - 1;
        if (m < 1) {
            m += 12;
        }
        if ((offset = m + (h = this.hour.getEarthBranch().getIndex() + 1)) > 12) {
            offset -= 12;
        }
        return SixtyCycle.fromName(HeavenStem.fromIndex((this.year.getHeavenStem().getIndex() + 1) * 2 + offset - 1).getName() + EarthBranch.fromIndex(offset + 1).getName());
    }

    @Deprecated
    public Duty getDuty() {
        return Duty.fromIndex(this.day.getEarthBranch().getIndex() - this.month.getEarthBranch().getIndex());
    }

    public List<SolarTime> getSolarTimes(int startYear, int endYear) {
        int[] nArray;
        ArrayList<SolarTime> l = new ArrayList<SolarTime>();
        int m = this.month.getEarthBranch().next(-2).getIndex();
        if (!HeavenStem.fromIndex((this.year.getHeavenStem().getIndex() + 1) * 2 + m).equals(this.month.getHeavenStem())) {
            return l;
        }
        int y = this.year.next(-57).getIndex() + 1;
        m *= 2;
        int h = this.hour.getEarthBranch().getIndex() * 2;
        if (h == 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 23;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = h;
        }
        int[] hours = nArray;
        int baseYear = startYear - 1;
        if (baseYear > y) {
            y += 60 * (int)Math.ceil((double)(baseYear - y) / 60.0);
        }
        while (y <= endYear) {
            SolarTime solarTime;
            SolarTerm term = SolarTerm.fromIndex(y, 3);
            if (m > 0) {
                term = term.next(m);
            }
            if ((solarTime = term.getJulianDay().getSolarTime()).getYear() >= startYear) {
                SolarDay solarDay = solarTime.getSolarDay();
                int d = this.day.next(-solarDay.getLunarDay().getSixtyCycle().getIndex()).getIndex();
                if (d > 0) {
                    solarDay = solarDay.next(d);
                }
                for (int hour : hours) {
                    SolarTime time;
                    int mi = 0;
                    int s = 0;
                    if (d == 0 && hour == solarTime.getHour()) {
                        mi = solarTime.getMinute();
                        s = solarTime.getSecond();
                    }
                    if (!(time = SolarTime.fromYmdHms(solarDay.getYear(), solarDay.getMonth(), solarDay.getDay(), hour, mi, s)).getLunarHour().getEightChar().equals(this)) continue;
                    l.add(time);
                }
            }
            y += 60;
        }
        return l;
    }

    @Override
    public String getName() {
        return String.format("%s %s %s %s", this.year, this.month, this.day, this.hour);
    }
}

