/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.eightchar;

import com.tyme.eightchar.ChildLimitInfo;
import com.tyme.eightchar.DecadeFortune;
import com.tyme.eightchar.EightChar;
import com.tyme.eightchar.Fortune;
import com.tyme.eightchar.provider.ChildLimitProvider;
import com.tyme.eightchar.provider.impl.DefaultChildLimitProvider;
import com.tyme.enums.Gender;
import com.tyme.enums.YinYang;
import com.tyme.lunar.LunarYear;
import com.tyme.sixtycycle.SixtyCycleYear;
import com.tyme.solar.SolarTerm;
import com.tyme.solar.SolarTime;

public class ChildLimit {
    public static ChildLimitProvider provider = new DefaultChildLimitProvider();
    protected EightChar eightChar;
    protected Gender gender;
    protected boolean forward;
    protected ChildLimitInfo info;

    public ChildLimit(SolarTime birthTime, Gender gender) {
        this.gender = gender;
        this.eightChar = birthTime.getLunarHour().getEightChar();
        boolean yang = YinYang.YANG == this.eightChar.getYear().getHeavenStem().getYinYang();
        boolean man = Gender.MAN == gender;
        this.forward = yang && man || !yang && !man;
        SolarTerm term = birthTime.getTerm();
        if (!term.isJie()) {
            term = term.next(-1);
        }
        if (this.forward) {
            term = term.next(2);
        }
        this.info = provider.getInfo(birthTime, term);
    }

    public static ChildLimit fromSolarTime(SolarTime birthTime, Gender gender) {
        return new ChildLimit(birthTime, gender);
    }

    public EightChar getEightChar() {
        return this.eightChar;
    }

    public Gender getGender() {
        return this.gender;
    }

    public boolean isForward() {
        return this.forward;
    }

    public int getYearCount() {
        return this.info.getYearCount();
    }

    public int getMonthCount() {
        return this.info.getMonthCount();
    }

    public int getDayCount() {
        return this.info.getDayCount();
    }

    public int getHourCount() {
        return this.info.getHourCount();
    }

    public int getMinuteCount() {
        return this.info.getMinuteCount();
    }

    public SolarTime getStartTime() {
        return this.info.getStartTime();
    }

    public SolarTime getEndTime() {
        return this.info.getEndTime();
    }

    public DecadeFortune getStartDecadeFortune() {
        return DecadeFortune.fromChildLimit(this, 0);
    }

    public DecadeFortune getDecadeFortune() {
        return DecadeFortune.fromChildLimit(this, -1);
    }

    public Fortune getStartFortune() {
        return Fortune.fromChildLimit(this, 0);
    }

    @Deprecated
    public LunarYear getEndLunarYear() {
        return LunarYear.fromYear(this.getStartTime().getLunarHour().getYear() + this.getEndTime().getYear() - this.getStartTime().getYear());
    }

    public SixtyCycleYear getStartSixtyCycleYear() {
        return SixtyCycleYear.fromYear(this.getStartTime().getYear());
    }

    public SixtyCycleYear getEndSixtyCycleYear() {
        return SixtyCycleYear.fromYear(this.getEndTime().getYear());
    }

    public int getStartAge() {
        return 1;
    }

    public int getEndAge() {
        int n = this.getEndSixtyCycleYear().getYear() - this.getStartSixtyCycleYear().getYear();
        return Math.max(n, 1);
    }
}

