/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.AbstractTyme;
import com.tyme.solar.SolarHalfYear;
import com.tyme.solar.SolarMonth;
import com.tyme.solar.SolarSeason;
import java.util.ArrayList;
import java.util.List;

public class SolarYear
extends AbstractTyme {
    protected int year;

    protected SolarYear(int year) {
        if (year < 1 || year > 9999) {
            throw new IllegalArgumentException(String.format("illegal solar year: %d", year));
        }
        this.year = year;
    }

    public static SolarYear fromYear(int year) {
        return new SolarYear(year);
    }

    public int getYear() {
        return this.year;
    }

    public int getDayCount() {
        if (1582 == this.year) {
            return 355;
        }
        return this.isLeap() ? 366 : 365;
    }

    public boolean isLeap() {
        if (this.year < 1600) {
            return this.year % 4 == 0;
        }
        return this.year % 4 == 0 && this.year % 100 != 0 || this.year % 400 == 0;
    }

    @Override
    public String getName() {
        return String.format("%d\u5e74", this.year);
    }

    @Override
    public SolarYear next(int n) {
        return SolarYear.fromYear(this.year + n);
    }

    public List<SolarMonth> getMonths() {
        ArrayList<SolarMonth> l = new ArrayList<SolarMonth>(12);
        for (int i = 0; i < 12; ++i) {
            l.add(SolarMonth.fromYm(this.year, i + 1));
        }
        return l;
    }

    public List<SolarSeason> getSeasons() {
        ArrayList<SolarSeason> l = new ArrayList<SolarSeason>(4);
        for (int i = 0; i < 4; ++i) {
            l.add(SolarSeason.fromIndex(this.year, i));
        }
        return l;
    }

    public List<SolarHalfYear> getHalfYears() {
        ArrayList<SolarHalfYear> l = new ArrayList<SolarHalfYear>(2);
        for (int i = 0; i < 2; ++i) {
            l.add(SolarHalfYear.fromIndex(this.year, i));
        }
        return l;
    }
}

